/*
 * Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NETDEV_OFFLOAD_PRIVATE_H
#define NETDEV_OFFLOAD_PRIVATE_H 1

#include "dpif.h"
#include "netdev.h"
#include "openvswitch/hmap.h"
#include "ovs-atomic.h"
#include "ovs-thread.h"

#ifdef  __cplusplus
extern "C" {
#endif

extern struct ovs_rwlock port_to_netdev_rwlock;

struct port_to_netdev_data {
    struct hmap_node portno_node; /* By (dpif_type, dpif_port.port_no). */
    struct hmap_node ifindex_node; /* By (dpif_type, ifindex). */
    struct netdev *netdev;
    struct dpif_port dpif_port;
    int ifindex;
    atomic_bool visible; /* Is this pairing visible externally. */
};

struct port_to_netdev_data *
netdev_ports_lookup(odp_port_t port_no, const char *dpif_type);

#ifdef  __cplusplus
}
#endif

#endif /* netdev-offload-private.h */
