/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2019-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef NETDEV_DOCA_VDPA_H
#define NETDEV_DOCA_VDPA_H 1

#include "netdev.h"

struct netdev_doca_vdpa_relay;
struct rte_mempool;
struct ovs_mutex;

/*
 * Functions that implement the relay forwarding for the netdev dpdkvdpa
 * which is defined and implemented in netdev-doca.
 * Each relay is associated with a port representor, which is a regular
 * dpdk netdev. The port representor is the calling context to the relay's
 * rx_recv function. The idle cycles of the port represntor's rx_recv are
 * used to forward packets between vf to vm and vice versa.
 */

void *
netdev_doca_vdpa_alloc_relay(void);
int
netdev_doca_vdpa_update_relay(struct netdev_doca_vdpa_relay *relay,
                              struct rte_mempool *mp,
                              int n_rxq);
int
netdev_doca_vdpa_rxq_recv_impl(struct netdev_doca_vdpa_relay *relay,
                               int pr_queue);
int
netdev_doca_vdpa_config_impl(struct netdev_doca_vdpa_relay *relay,
                             uint16_t port_id,
                             const char *vm_socket,
                             const char *vf_devargs,
                             int max_queues,
                             bool hw_mode);
void
netdev_doca_vdpa_destruct_impl(struct netdev_doca_vdpa_relay *relay);
int
netdev_doca_vdpa_get_custom_stats_impl(struct netdev_doca_vdpa_relay *relay,
                                       struct netdev_custom_stats *cstm_stats,
                                       struct ovs_mutex *dev_mutex,
                                       const struct netdev *netdev,
                                       int (*cb)(const struct netdev *,
                                                 struct netdev_custom_stats *));

#endif /* netdev-doca-vdpa.h */
