#ifndef LINUX_26_COMPAT_H
#define LINUX_26_COMPAT_H

#define LINUX_BACKPORT(__sym) backport_ ##__sym

/* Include the autogenerated header file */
#include "../../compat/config.h"

#include <linux/version.h>
#include <linux/kconfig.h>
#include <linux/if.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/uidgid.h>

/*
 * The define overwriting module_init is based on the original module_init
 * which looks like this:
 * #define module_init(initfn)					\
 *	static inline initcall_t __inittest(void)		\
 *	{ return initfn; }					\
 *	int init_module(void) __attribute__((alias(#initfn)));
 *
 * To the call to the initfn we added the symbol dependency on compat
 * to make sure that compat.ko gets loaded for any compat modules.
 */
void mlx_backport_dependency_symbol(void);

#undef module_init
#define module_init(initfn)                                             \
	static int __init __init_backport(void)                         \
	{                                                               \
		mlx_backport_dependency_symbol();                           \
		return initfn();                                        \
	}                                                               \
	int init_module(void)  __copy(initfn)  \
			__attribute__((alias("__init_backport"))); \
			 ___ADDRESSABLE(init_module, __initdata);


#endif /* LINUX_26_COMPAT_H */
