#ifndef _COMPAT_LINUX_BUILD_BUG_H
#define _COMPAT_LINUX_BUILD_BUG_H

/* Include the autogenerated header file */
#include "../../compat/config.h"

#include_next <linux/build_bug.h>

/* Force a compilation error if a constant expression is not a power of 2 */
#ifndef __BUILD_BUG_ON_NOT_POWER_OF_2
#define __BUILD_BUG_ON_NOT_POWER_OF_2(n)        \
        BUILD_BUG_ON(((n) & ((n) - 1)) != 0)
#endif

/**
 * static_assert - check integer constant expression at build time
 *
 * static_assert() is a wrapper for the C11 _Static_assert, with a
 * little macro magic to make the message optional (defaulting to the
 * stringification of the tested expression).
 *
 * Contrary to BUILD_BUG_ON(), static_assert() can be used at global
 * scope, but requires the expression to be an integer constant
 * expression (i.e., it is not enough that __builtin_constant_p() is
 * true for expr).
 *
 * Also note that BUILD_BUG_ON() fails the build if the condition is
 * true, while static_assert() fails the build if the expression is
 * false.
 */
#ifndef HAVE_STATIC_ASSERT
#define static_assert(expr, ...) __static_assert(expr, ##__VA_ARGS__, #expr)
#define __static_assert(expr, msg, ...) _Static_assert(expr, msg)
#endif

#endif /* _COMPAT_LINUX_BUILD_BUG_H */
