%if %{undefined make_build}
%global make_build %{__make} %{?_smp_mflags}
%endif

%if 0%{?_ver:1}
%define ver %{_ver}
%else
%define ver 3.10
%endif

%if 0%{?_rel:1}
%define rel %{_rel}
%else
%define rel 1
%endif

Summary: Network Benchmarking Utility for high-performance systems
Name: sockperf
Version: %{?ver}
Release: %{?rel}%{?dist}
License: BSD-3-Clause
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
Source: %{name}-%{version}.tar.gz
BuildRequires: gcc-c++
BuildRequires: make
BuildRequires: automake
BuildRequires: autoconf
BuildRequires: libtool
BuildRequires: m4
BuildRequires: perl
ExclusiveArch: i386 i486 i586 i686 x86_64 ppc64 ppc64le aarch64 s390x
Url: https://github.com/Mellanox/sockperf

%description
sockperf is a network benchmarking utility over socket API that was designed
for testing performance (latency and throughput) of high-performance systems.
It covers most of the socket API calls and options and can measure latency
of each discrete packet at sub-nanosecond resolution.

%prep
%setup -n %{name}-%{version}

%build
# Run autogen.sh if configure doesn't exist
if [ ! -f configure ]; then
    ./autogen.sh
fi
%configure
%make_build

%install
rm -rf $RPM_BUILD_ROOT
%make_install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/sockperf
%doc /usr/share/doc/sockperf/README.md
%doc /usr/share/doc/sockperf/authors
%doc /usr/share/doc/sockperf/news
%doc /usr/share/doc/sockperf/version
%doc /usr/share/doc/sockperf/copying
%license copying

%changelog
* Wed Jan 08 2025 Gal Noam <gnoam@nvidia.com> 3.10-1
- Initial package for sockperf v3.10
- Network benchmarking utility from Mellanox 