/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2021-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: GPL-2.0-only or BSD-2-Clause
 */

#ifndef _VALGRIND_H_
#define _VALGRIND_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* Valgrind compatibility */
#ifndef NVALGRIND
#include <valgrind/memcheck.h>
#ifndef VALGRIND_MAKE_MEM_DEFINED
#define VALGRIND_MAKE_MEM_DEFINED(p, n) VALGRIND_MAKE_READABLE(p, n)
#endif
#ifndef VALGRIND_MAKE_MEM_UNDEFINED
#define VALGRIND_MAKE_MEM_UNDEFINED(p, n) VALGRIND_MAKE_WRITABLE(p, n)
#endif
#else
#define VALGRIND_MAKE_MEM_DEFINED(p, n)
#define VALGRIND_MAKE_MEM_UNDEFINED(p, n)
#define VALGRIND_MAKE_MEM_NOACCESS(p, n)
#define VALGRIND_CREATE_MEMPOOL(n, p, x)
#define VALGRIND_DESTROY_MEMPOOL(p)
#define VALGRIND_MEMPOOL_ALLOC(n, p, x)
#define VALGRIND_MEMPOOL_FREE(n, p)
#define RUNNING_ON_VALGRIND 0
#endif

#endif
