/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2023-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef DOCA_PIPE_GROUP_H
#define DOCA_PIPE_GROUP_H

#include <doca_flow.h>

#include "cmap.h"
#include "openvswitch/list.h"
#include "openvswitch/thread.h"
#include "ovs-doca.h"

struct doca_flow_pipe;
struct doca_flow_pipe_cfg;
struct doca_mirror_ctx;
struct doca_offload_esw_ctx;
struct doca_pipe_group_ctx;
struct doca_pipe_group_mask_ctx;
struct doca_split_prefix_ctx;
struct netdev;
struct ovs_doca_flow_actions;
struct ovs_doca_flow_match;

struct too_big_map {
    struct cmap map;
    struct ovs_mutex lock;
};

struct doca_pipe_group_mask_entry {
    struct doca_flow_pipe_entry *entry;
    struct doca_pipe_group_mask_ctx *mctx;
};

struct doca_pipe_group_ctx *
doca_pipe_group_ctx_ref(struct netdev *netdev, uint32_t group_id,
                        struct doca_pipe_group_mask_ctx *prefix_mask_ctx);
void
doca_pipe_group_ctx_unref(struct doca_pipe_group_ctx *group_ctx);

struct doca_flow_pipe *
doca_pipe_group_get_pipe(struct doca_pipe_group_ctx *group_ctx);

void
doca_pipe_group_set_suffix_group(struct doca_pipe_group_mask_ctx *mask_ctx,
                                 struct doca_pipe_group_ctx *suffix_group_ctx);

doca_error_t
doca_pipe_group_add_entry(struct netdev *netdev,
                          uint16_t pipe_queue,
                          uint32_t priority,
                          struct doca_pipe_group_ctx *group_ctx,
                          const struct ovs_doca_flow_match *match,
                          struct ovs_doca_flow_match *match_mask,
                          struct ovs_doca_flow_actions *actions,
                          struct ovs_doca_flow_actions *actions_mask,
                          const struct doca_flow_action_descs *action_descs,
                          struct doca_flow_monitor *monitor,
                          const struct doca_flow_fwd *fwd,
                          struct doca_pipe_group_mask_ctx **mask_ctx,
                          struct doca_flow_pipe_entry **entry)
    OVS_EXCLUDED(mgmt_queue_lock);

void
doca_pipe_group_ctx_resize_end_list(struct ovs_list *list);

bool
doca_pipe_group_is_ct_zone_group_id(uint32_t group);

struct doca_pipe_group_mask_ctx *
doca_pipe_group_mask_ctx_ref(struct netdev *netdev,
                             struct doca_pipe_group_ctx *group_ctx,
                             const struct ovs_doca_flow_match *match,
                             struct ovs_doca_flow_match *match_mask,
                             struct ovs_doca_flow_actions *actions,
                             struct ovs_doca_flow_actions *actions_mask,
                             const struct doca_flow_action_desc *desc,
                             const struct doca_flow_monitor *monitor,
                             const struct doca_flow_fwd *fwd,
                             uint32_t priority, bool *too_big,
                             uint64_t allowed_queues_bitmap);

void
doca_pipe_group_mask_ctx_unref(struct doca_pipe_group_mask_ctx *mask_ctx);

void
doca_pipe_group_too_big_map_init(struct too_big_map *tbm);

void
doca_pipe_group_too_big_map_uninit(struct too_big_map *tbm);

void
doca_pipe_group_pipe_destroy(struct doca_offload_esw_ctx *esw_ctx, struct doca_flow_pipe *pipe);

doca_error_t
doca_pipe_cfg_allow_queues(struct doca_flow_pipe_cfg *cfg, uint64_t queues_bitmap);

doca_error_t
doca_pipe_cfg_allow_one_queue(struct doca_flow_pipe_cfg *cfg, unsigned int qid);

#endif /* DOCA_PIPE_GROUP_H */
