/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2023-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef DOCA_ACTION_SPLIT_H
#define DOCA_ACTION_SPLIT_H

#include <doca_flow.h>

#include "dpdk-offload-provider.h"
#include "ovs-doca.h"

typedef int (*doca_offload_create_cb)(struct netdev *netdev,
                                      const struct rte_flow_attr *attr,
                                      struct rte_flow_item *items,
                                      struct rte_flow_action *actions,
                                      struct dpdk_offload_handle *doh,
                                      struct rte_flow_error *error);
typedef int (*doca_offload_destroy_cb)(struct netdev *netdev, struct dpdk_offload_handle *doh,
                                       struct rte_flow_error *error);

int
doca_action_split_create(doca_offload_create_cb offload_cb,
                         doca_offload_destroy_cb destroy_cb,
                         struct netdev *netdev,
                         const struct rte_flow_attr *attr,
                         struct rte_flow_item *items,
                         struct rte_flow_action *actions,
                         struct dpdk_offload_handle *doh,
                         struct rte_flow_error *error);
int
doca_action_split_destroy(doca_offload_destroy_cb destroy_cb,
                          struct netdev *netdev,
                          struct dpdk_offload_handle *doh,
                          struct rte_flow_error *error);

#endif /* DOCA_ACTION_SPLIT_H */
