#ifndef _COMPAT_LINUX_LIST_H
#define _COMPAT_LINUX_LIST_H

/* Include the autogenerated header file */
#include "../../compat/config.h"

#include_next <linux/list.h>

#ifndef HAVE_LIST_BULK_MOVE_TAIL
static inline void list_bulk_move_tail(struct list_head *head,
		struct list_head *first,
		struct list_head *last)
{
	first->prev->next = last->next;
	last->next->prev = first->prev;

	head->prev->next = first;
	first->prev = head->prev;

	last->next = head;
	head->prev = last;
}
#endif

#ifndef HAVE_LIST_IS_FIRST
static inline int list_is_first(const struct list_head *list, const struct list_head *head)
{
	return list->prev == head;
}
#endif

#ifndef HAVE_LIST_ENTRY_IS_HEAD
#define list_entry_is_head(pos, head, member)                          \
               (&pos->member == (head))
#endif

#endif /* _COMPAT_LINUX_LIST_H */
