#ifndef _COMPAT_LINUX_ETHTOOL_H
#define _COMPAT_LINUX_ETHTOOL_H

#include "../../compat/config.h"

#include_next <linux/ethtool.h>

#ifndef HAVE_ETHTOOL_PUTS
static inline void ethtool_puts(u8 **data, const char *str)
{
	strscpy(*data, str, ETH_GSTRING_LEN);
	*data += ETH_GSTRING_LEN;
}
#endif

#ifndef ETH_MODULE_SFF_8436_MAX_LEN
#define ETH_MODULE_SFF_8636_MAX_LEN     640
#define ETH_MODULE_SFF_8436_MAX_LEN     640
#endif

#ifndef HAVE_ETHTOOL_PAUSE_STATS
struct ethtool_pause_stats {
	u64 tx_pause_frames;
	u64 rx_pause_frames;
};
#endif
#ifndef HAVE_ETHTOOL_RMON_HIST_RANGE
struct ethtool_rmon_hist_range {
	u16 low;
	u16 high;
};

#define ETHTOOL_RMON_HIST_MAX   10
struct ethtool_rmon_stats {
	u64 undersize_pkts;
	u64 oversize_pkts;
	u64 fragments;
	u64 jabbers;

	u64 hist[ETHTOOL_RMON_HIST_MAX];
	u64 hist_tx[ETHTOOL_RMON_HIST_MAX];
};
#endif

/* check whether ethtool_fec_config_bits is defined, but without LLRS bit */
#ifndef ETHTOOL_FEC_LLRS
#define ETHTOOL_FEC_LLRS_BIT		(ETHTOOL_FEC_BASER_BIT + 1)
#define ETHTOOL_FEC_LLRS		(1 << ETHTOOL_FEC_LLRS_BIT)
#endif /* ETHTOOL_FEC_LLRS */

#define SPEED_25000 25000
#define SPEED_50000 50000
#define SPEED_100000 100000
#ifndef ETHTOOL_LINK_MODE_25000baseCR_Full_BIT
#define ETHTOOL_LINK_MODE_25000baseCR_Full_BIT 31
#define ETHTOOL_LINK_MODE_25000baseKR_Full_BIT 32
#define ETHTOOL_LINK_MODE_25000baseSR_Full_BIT 33
#define ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT 34
#define ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT 35
#define ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT 36
#define ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT 37
#define ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT 38
#define ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT 39
#endif
#ifndef ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT
#define ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT 40
#endif
#ifndef ETHTOOL_LINK_MODE_1000baseX_Full_BIT
#define ETHTOOL_LINK_MODE_1000baseX_Full_BIT 41
#define ETHTOOL_LINK_MODE_10000baseCR_Full_BIT 42
#define ETHTOOL_LINK_MODE_10000baseSR_Full_BIT 43
#define ETHTOOL_LINK_MODE_10000baseLR_Full_BIT 44
#define ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT 45
#define ETHTOOL_LINK_MODE_10000baseER_Full_BIT 46
#endif
#ifndef ETHTOOL_LINK_MODE_2500baseT_Full_BIT
#define ETHTOOL_LINK_MODE_2500baseT_Full_BIT 47
#define ETHTOOL_LINK_MODE_5000baseT_Full_BIT 48
#endif
#ifndef ETHTOOL_LINK_MODE_FEC_NONE_BIT
#define ETHTOOL_LINK_MODE_FEC_NONE_BIT 49
#define ETHTOOL_LINK_MODE_FEC_RS_BIT 50
#define ETHTOOL_LINK_MODE_FEC_BASER_BIT 51
#endif

#ifndef ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT
#define ETHTOOL_LINK_MODE_50000baseKR_Full_BIT 52
#define ETHTOOL_LINK_MODE_50000baseSR_Full_BIT 53
#define ETHTOOL_LINK_MODE_50000baseCR_Full_BIT 54
#define ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT 55
#define ETHTOOL_LINK_MODE_50000baseDR_Full_BIT 56
#define ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT 57
#define ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT 58
#define ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT 59
#define ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT 60
#define ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT 61
#define ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT 62
#define ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT 63
#define ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT 64
#define ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT 65
#define ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT 66
#define ETHTOOL_LINK_MODE_100baseT1_Full_BIT 67
#define ETHTOOL_LINK_MODE_1000baseT1_Full_BIT 68
#define ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT 69
#define ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT 70
#define ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT 71
#define ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT 72
#define ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT 73
/* must be last entry */
#define ETHTOOL_LINK_MODE_FEC_LLRS_BIT 74
#endif

#ifndef ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT
#define ETHTOOL_LINK_MODE_FEC_LLRS_BIT                    74
#define ETHTOOL_LINK_MODE_100000baseKR_Full_BIT           75
#define ETHTOOL_LINK_MODE_100000baseSR_Full_BIT           76
#define ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT     77
#define ETHTOOL_LINK_MODE_100000baseCR_Full_BIT           78
#define ETHTOOL_LINK_MODE_100000baseDR_Full_BIT           79
#define ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT          80
#define ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT          81
#define ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT  82
#define ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT          83
#define ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT          84
#define ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT          85
#define ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT          86
#define ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT  87
#define ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT          88
#define ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT          89
#endif

#ifndef SPEED_400000
#define SPEED_400000 400000
#endif

#ifndef ETHTOOL_LINK_MODE_100baseFX_Half_BIT
#define ETHTOOL_LINK_MODE_100baseFX_Half_BIT 90
#define ETHTOOL_LINK_MODE_100baseFX_Full_BIT 91
#endif

#ifndef SPEED_800000
#define SPEED_800000 800000
#define ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT          93
#define ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT          94
#define ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT          95
#define ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT        96
#define ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT          97
#define ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT          98
#endif

#ifndef ETHTOOL_LINK_MODE_200000baseCR_Full_BIT
#define ETHTOOL_LINK_MODE_200000baseCR_Full_BIT		  103
#define ETHTOOL_LINK_MODE_200000baseKR_Full_BIT		  104
#define ETHTOOL_LINK_MODE_200000baseDR_Full_BIT		  105
#define ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT	  106
#define ETHTOOL_LINK_MODE_200000baseSR_Full_BIT		  107
#define ETHTOOL_LINK_MODE_200000baseVR_Full_BIT		  108
#define ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT	  109
#define ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT	  110
#define ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT	  111
#define ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT	  112
#define ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT	  113
#define ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT	  114
#define ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT	  115
#define ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT	  116
#define ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT	  117
#define ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT	  118
#define ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT	  119
#define ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT	  120
#endif

#ifndef SPEED_1600000
#define SPEED_1600000 1600000
#define ETHTOOL_LINK_MODE_1600000baseCR8_Full_BIT	  121
#define ETHTOOL_LINK_MODE_1600000baseKR8_Full_BIT	  122
#define ETHTOOL_LINK_MODE_1600000baseDR8_Full_BIT	  123
#define ETHTOOL_LINK_MODE_1600000baseDR8_2_Full_BIT	  124
#endif

#define SUPPORTED_100000baseCR4_Full 0
#define ADVERTISED_100000baseCR4_Full 0
#define SUPPORTED_100000baseSR4_Full 0
#define ADVERTISED_100000baseSR4_Full 0
#define SUPPORTED_100000baseKR4_Full 0
#define ADVERTISED_100000baseKR4_Full 0
#define SUPPORTED_1000000baseLR4_Full 0
#define ADVERTISED_1000000baseLR4_Full 0
#define SUPPORTED_100baseTX_Full 0
#define ADVERTISED_100baseTX_Full 0
#define SUPPORTED_25000baseCR_Full 0
#define ADVERTISED_25000baseCR_Full 0
#define SUPPORTED_25000baseKR_Full 0
#define ADVERTISED_25000baseKR_Full 0
#define SUPPORTED_25000baseSR_Full 0
#define ADVERTISED_25000baseSR_Full 0
#define SUPPORTED_50000baseCR2_Full 0
#define ADVERTISED_50000baseCR2_Full 0
#define SUPPORTED_50000baseKR2_Full 0
#define ADVERTISED_50000baseKR2_Full 0

#endif /* _COMPAT_LINUX_ETHTOOL_H */
