// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef HCACAP_H
#define HCACAP_H

#include <stddef.h>
#include <stdint.h>

#include "vfio_mlx5.h"
#include "abi.h"

/* PRM cap types */

enum mlx5_cap_mode {
	HCA_CAP_OPMOD_MAX = 0,
	HCA_CAP_OPMOD_CUR = 1,
};

enum mlx5_cap_type {
	MLX5_CAP_GEN = 0,
	MLX5_CAP_ROCE = 4,
	MLX5_CAP_GEN_2 = 32,
};

/* size 256 for future expansion
 * keep each cap type in own struct and cap fields should have identical name
 * as PRM, so we can use macros similar as we do in the kernel driver
 * maybe one day will switch to hca_cap_out caching as we do in the driver
 * so all we need to do in that case is to change macro implementation
 */
struct __packed_aligned(256) mlx5_dev_caps {
	struct {
		uint8_t fast_teardown : 1;
		uint8_t uar_4k : 1;
	} __packed_aligned(64) general;
	struct {
		uint8_t query_adjacent_functions_id : 1;
		uint16_t delegate_vhca_management_profiles;
		uint16_t delegated_vhca_max;
		uint16_t delegate_vhca_max;
	} __packed_aligned(64) cap2;
};

#define MLX5_CAP_GEN(dev, field) ((dev)->caps).general.field
#define MLX5_CAP_GEN_2(dev, field) ((dev)->caps).cap2.field

int mlx5_get_cap(struct vfio_mlx5_dev *dev, enum mlx5_cap_type cap_type,
		 enum mlx5_cap_mode cap_mode, uint8_t func_id, void *out);
int mlx5_vfio_set_hca_cap(struct vfio_mlx5_dev *dev);

#endif /* HCACAP_H */
