// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef __FUNC_H__
#define __FUNC_H__

#include <stdint.h>

#include "abi.h"

struct __packed_aligned(32) mlx5_adj_pf {
	uint16_t func_id;
	uint16_t vhca_id;
	uint8_t pci_bus;
	uint8_t pci_function;
};

struct vfio_mlx5_dev;

int mlx5_func_enable_hca(struct vfio_mlx5_dev *dev, uint16_t func_id);

/* entry point to setup/teardown vf function */
int mlx5_func_setup_vfs(struct vfio_mlx5_dev *dev, unsigned int nvfs);
void mlx5_func_teardown_vfs(struct vfio_mlx5_dev *dev, unsigned int nvfs);

#endif /* __FUNC_H__ */
