#
# Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES, ALL RIGHTS RESERVED.
#
# This software product is a proprietary product of NVIDIA CORPORATION &
# AFFILIATES (the "Company") and all right, title, and interest in and to the
# software product, including all associated intellectual property rights, are
# and shall remain exclusively with the Company.
#
# This software product is governed by the End User License Agreement
# provided with the software product.
#

Name: libvfio-mlx5
Version: 1.1.4
Release: 1
Summary: VFIO based MLX5 User Space Driver library
License: BSD-3-Clause
URL: https://docs.nvidia.com/doca/sdk/doca+release+notes/index.html

%define build_name %{name}-%{version}-%{release}
Source0: %{build_name}.tar.gz

BuildRequires: meson
BuildRequires: gcc

%description
This package provides the VFIO based MLX5 User Space Driver, including
the shared library, development files, and basic sample application.
It enables user space applications to directly access MLX5 hardware
through the VFIO framework, providing high-performance networking capabilities.

The package includes:
- Shared library (libvfio_mlx5.so.*) for runtime applications
- Development files (headers, static library) for building applications
- Basic sample application (vfio_mlx5) demonstrating library usage

The library offers a comprehensive API for managing MLX5 devices, handling
memory management, command queues, and hardware capabilities in user space.

%prep
%autosetup -n %{build_name}

%build
%meson %{?meson_param}
%meson_build

%install
%meson_install

%files
%{_libdir}/libvfio_mlx5.so*
%{_libdir}/libvfio_mlx5.a
%{_includedir}/*
%{_sbindir}/vfio_mlx5
%{_mandir}/man8/vfio_mlx5.8*
%{_docdir}/%{name}/LICENSE
%{_docdir}/%{name}/README.md

%changelog
* Fri Jun 13 2025 NVIDIA CORPORATION <networking-support@nvidia.com> - 1.0.0-1
- Initial RPM package for VFIO based MLX5 User Space Driver
- Single package includes runtime library, development files, and basic sample application
