#! /usr/bin/env sh

if [ ! -e .git ] || [ ! git --version >/dev/null 2>&1 ]; then
    # Do not deploy anything if this is not a git-based installation
    exit 0
fi

# Longest common prefix.
# $1=/a/b/c/d $2=/a/b/e/f => /a/b/
lcprefix() { printf "%s\n%s\n" "$1" "$2" | sed -e 'N;s/^\(.*\).*\n\1.*$/\1/'; }

# Relative path from $1 to $2.
# Takes canonical, absolute path as inputs.
# Prints relative path from file $1 to file $2
relpath() (
    if [ "$1" = "/" ]; then src=""; else src="$1"; fi
    p=$(lcprefix "$src" "$2")
    [ "${src#${p}}" ] || printf "./"
    printf "%s" "${src#${p%/}}" |sed 's;[^/]*$;;' |sed 's;[^/]*/;../;g'
    printf "%s" "${2#/${p#/}}" |sed 's;^/;;'
)

TOPDIR="$(git rev-parse --show-toplevel)"
TARGET="${TOPDIR}/.git/hooks"
SOURCE="${TOPDIR}/utilities/git-hooks"

for hook in "$SOURCE"/*
do
    link="${TARGET}/$(basename $hook)"
    path="$(relpath $TARGET $hook)"
    if [ ! -e "$path" ]; then
        ln -sfn "$path" "$link"
    fi
done
