#!/bin/bash

srcdir=$PWD
[ "${srcdir}" != "${srcdir%%'/_debian'}" ] && srcdir="$srcdir/.."
boot_git_sha="$srcdir/boot_git_sha.txt"
version_file="$srcdir/VERSION"
if test -e "$srcdir/.git" && (git --version) >/dev/null 2>&1; then
    EXTRA=$(grep -m1 -E "^RELEASE_EXTRA = " "$srcdir/Makefile.am" | cut -d = -f 2 | tr -d ' ' 2>/dev/null)
    # old tag format 3.1.0-0001
    # new tag format 3.1.0001
    RELEASE_DESC=$(git describe --tags --match "[0-9]*.[0-9]*.[0-9]*" 2>/dev/null)
    [ "$RELEASE_DESC" ] || RELEASE_DESC=$(git rev-parse --short HEAD 3>/dev/null)
    if echo $RELEASE_DESC | grep -q "[0-9].[0-9].[0-9]-[0-9][0-9][0-9][0-9]" ; then
        # convert old tag to new version.
        VERSION=$(echo "$RELEASE_DESC" | sed -E 's/^([0-9]+\.[0-9]+\.[0-9]+)-0([0-9]+).*/\1\2/')
        RELEASE_DESC=$(echo "$RELEASE_DESC" | cut -d - -f 3- 2>/dev/null)
    else
        VERSION=$(echo "$RELEASE_DESC" | cut -d - -f 1 2>/dev/null)
        RELEASE_DESC=$(echo "$RELEASE_DESC" | cut -d - -f 2- 2>/dev/null)
        [ "$RELEASE_DESC" == "$VERSION" ] && RELEASE_DESC=""
    fi
    cur_version=$(cat $version_file 2>/dev/null)
    [ "$VERSION" != "$cur_version" ] && echo "$VERSION" > $version_file
    [ "$RELEASE_DESC" ] && RELEASE_DESC="$RELEASE_DESC-$EXTRA" || RELEASE_DESC="$EXTRA"
    echo "$RELEASE_DESC" > "$boot_git_sha"
fi
[ ! -f $version_file ] && touch $version_file
cat "$boot_git_sha" 2>/dev/null
