/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2023-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#include <config.h>

#include "netdev-doca.h"
#include "netdev-offload-provider.h"
#include "ovs-doca.h"
#include "smap.h"

struct doca_flow_resource_meter_cfg;
struct rte_eth_stats;
struct rte_mtr_error;
struct rte_mtr_stats;

int
ovs_doca_init(const struct smap *ovs_other_config OVS_UNUSED)
{
    return 0;
}

void
ovs_doca_status(const struct ovsrec_open_vswitch *cfg)
{
    if (cfg) {
        ovsrec_open_vswitch_set_doca_initialized(cfg, false);
        ovsrec_open_vswitch_set_doca_version(cfg, "none");
    }
}

bool
ovs_doca_enabled(void)
{
    return false;
}

bool
ovs_doca_initialized(void)
{
    return false;
}

void
print_ovs_doca_release(void)
{
}

void
print_doca_version(void)
{
}

void
ovs_doca_register_classes(const struct smap *ovs_other_config OVS_UNUSED)
{
#ifdef DPDK_NETDEV
    netdev_doca_register(ovs_other_config);
    netdev_register_flow_api_provider(&netdev_offload_doca);
#endif
}

void
ovs_doca_mempool_destroy(struct ovs_doca_mempool *odmp OVS_UNUSED)
{
}

struct ovs_doca_mempool *
ovs_doca_mempool_create(unsigned n OVS_UNUSED, unsigned elt_size OVS_UNUSED)
{
    return NULL;
}

void
ovs_doca_mempool_free(struct ovs_doca_mempool *odmp OVS_UNUSED,
                      void *obj OVS_UNUSED)
{
    ovs_assert(false);
}

int
ovs_doca_mempool_alloc(struct ovs_doca_mempool *odmp OVS_UNUSED, void **obj_p)
{
    ovs_assert(false);
    *obj_p = NULL;
    return -1;
}

int
ovs_doca_port_start(struct netdev *netdev OVS_UNUSED,
                    struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                    int socket_id OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_port_stop(struct netdev *netdev OVS_UNUSED,
                   struct ovs_doca_netdev_data *dev_data OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_dev_probe(struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                   const char *devargs OVS_UNUSED)
{
    return -1;
}

void
ovs_doca_dev_close(struct ovs_doca_netdev_data *dev_data OVS_UNUSED)
{
}

void
ovs_doca_set_properties(struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                        uint16_t port_id OVS_UNUSED,
                        const char *devargs OVS_UNUSED,
                        uint16_t *esw_mgr_port_id OVS_UNUSED,
                        bool *attached OVS_UNUSED,
                        int *n_rxq OVS_UNUSED)
{
}

int
ovs_doca_rx_burst(struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                  uint16_t queue_id OVS_UNUSED,
                  struct dp_packet_batch *batch OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_eth_stats_get(struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                       struct rte_eth_stats *rte_stats OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_get_custom_stats(const struct netdev *netdev OVS_UNUSED,
                          const struct ovs_doca_netdev_data *dev_data OVS_UNUSED,
                          const struct ovs_doca_tx_stats *tx_stats OVS_UNUSED,
                          struct netdev_custom_stats *custom_stats OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_sw_meter_init(struct netdev *netdev OVS_UNUSED)
{
    return -1;
}

void
ovs_doca_sw_meter_uninit(struct netdev *netdev OVS_UNUSED)
{
}

int
ovs_doca_get_esw_n_rxq(struct ovs_doca_netdev_data *dev_data OVS_UNUSED)
{
    return -1;
}

struct ds *
ovs_doca_packet_ds_put_hex(struct ds *s, struct dp_packet *b OVS_UNUSED,
                           uint32_t max_bytes OVS_UNUSED)
{
    return s;
}

bool
ovs_doca_is_offload_trace_enabled(void)
{
    return false;
}

int
ovs_doca_create_meter(uint32_t of_meter_id OVS_UNUSED,
                      struct ofputil_meter_config *config OVS_UNUSED,
                      struct doca_flow_resource_meter_cfg *meter_cfg OVS_UNUSED,
                      struct rte_mtr_error *error OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_delete_meter(uint16_t port_id OVS_UNUSED, uint32_t of_meter_id OVS_UNUSED,
                      struct rte_mtr_error *error OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_mtr_stats_read(uint16_t port_id OVS_UNUSED, uint32_t dp_meter_id OVS_UNUSED,
                        struct rte_mtr_stats *stats OVS_UNUSED,
                        struct rte_mtr_error *error OVS_UNUSED)
{
    return -1;
}

int
ovs_doca_pre_miss_rules_update(struct netdev *netdev OVS_UNUSED,
                               const char *pre_miss_rules OVS_UNUSED)
{
    return -1;
}
