/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2009-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef DPIF_DOCA_TCPDUMP_H
#define DPIF_DOCA_TCPDUMP_H 1

#include <config.h>

#include "dp-packet.h"
#include "dpif-doca-tcpdump-hooks.h"
#include "ovs-atomic.h"

extern atomic_bool dpif_doca_tcpdump_enable;

void dpif_doca_tcpdump_init(void);
void dpif_doca_tcpdump_send_batch__(const struct dp_packet_batch *batch,
                                    const char *dev_name,
                                    enum dpif_doca_tcpdump_hook hook);

static inline void
dpif_doca_tcpdump_send_batch(const struct dp_packet_batch *batch,
                             const char *dev_name,
                             enum dpif_doca_tcpdump_hook hook)
{
    bool enabled;

    atomic_read_relaxed(&dpif_doca_tcpdump_enable, &enabled);
    if (OVS_LIKELY(!enabled)) {
        return;
    }

    if (OVS_UNLIKELY(dp_packet_batch_is_empty(batch))) {
        return;
    }

    dpif_doca_tcpdump_send_batch__(batch, dev_name, hook);
}

#endif /* dpif-doca-tcpdump.h */
