/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2008-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef DPIF_DOCA_PRIVATE_H
#define DPIF_DOCA_PRIVATE_H 1

/* This header includes the various dpif-doca components' header
 * files in the appropriate order. Unfortunately there is a strict
 * requirement in the include order due to dependences between components.
 * E.g:
 *  DFC/EMC/SMC requires the netdev_flow_key struct
 *  PMD thread requires DFC_flow struct
 *
 */
#include "dpif-doca-private-flow.h"
#include "dpif-doca-private-dpcls.h"
#include "dpif-doca-private-dfc.h"
#include "dpif-doca-private-thread.h"

/* Allow other implementations to lookup the DPCLS instances. */
struct dpcls *
dp_doca_pmd_lookup_dpcls(struct dp_doca_pmd_thread *pmd,
                         odp_port_t in_port);

/* Allow other implementations to execute actions on a batch. */
void
dp_doca_batch_execute(struct dp_doca_pmd_thread *pmd,
                      struct dp_packet_batch *packets,
                      struct dpcls_rule *rule,
                      uint32_t bytes,
                      uint32_t sample_bytes,
                      uint16_t tcp_flags);

int
dp_doca_hw_flow(struct dp_doca_pmd_thread *pmd,
                struct dp_packet *packet,
                struct dp_doca_flow **flow,
                bool dump);

#endif /* dpif-doca-private.h */
