// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef VFIO_SAMPLE_H
#define VFIO_SAMPLE_H

#include <stdint.h>
#include <stdbool.h>

#define PCI_NAME_MAX 128
#define SYSFS_PATH_MAX 256

struct vfio_pci_dev {
	char pci_bdf_vf_token[PCI_NAME_MAX];
	char vfio_path[SYSFS_PATH_MAX];
	int device_fd;
	int group_fd;
	int container_fd;
	int event_fd;
};

uint64_t get_physical_address(const void *vaddr);

/* VFIO container management */
int vfio_container_fd_open(bool noiommu);
void vfio_container_fd_close(int container_fd);

/* VFIO device management */
int sysfs_pci2vfio_path(const char *pci_name, char *vfio_path, bool noiommu);
int vfio_pci_dev_open(int container_fd, const char *pci_name,
		      struct vfio_pci_dev *vdev, bool noiommu);
void vfio_pci_dev_close(struct vfio_pci_dev *vdev);

/* VFIO memory management - NOTE: Memory registration is not supported in noiommu mode */
int vfio_mem_register(int container_fd, const void *vaddr, uint64_t iova,
		      uint64_t size);
void vfio_mem_unregister(int container_fd, uint64_t iova, uint64_t size);

/* VFIO interrupt management */
int vfio_interrupt_fd_open(int device_fd);
void vfio_interrupt_fd_close(int irq_eventfd);

#endif /* VFIO_H */
