// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef IFC_H
#define IFC_H

#include <stdint.h>

enum {
	MLX5_CMD_OP_QUERY_HCA_CAP = 0x100,
	MLX5_CMD_OP_INIT_HCA = 0x102,
	MLX5_CMD_OP_TEARDOWN_HCA = 0x103,
	MLX5_CMD_OP_ENABLE_HCA = 0x104,
	MLX5_CMD_OP_DISABLE_HCA = 0x105,
	MLX5_CMD_OP_QUERY_PAGES = 0x107,
	MLX5_CMD_OP_MANAGE_PAGES = 0x108,
	MLX5_CMD_OP_SET_HCA_CAP = 0x109,
	MLX5_CMD_OP_QUERY_ISSI = 0x10a,
	MLX5_CMD_OP_SET_ISSI = 0x10b,
	MLX5_CMD_OP_CREATE_MKEY = 0x200,
	MLX5_CMD_OP_DESTROY_MKEY = 0x202,
	MLX5_CMD_OP_CREATE_EQ = 0x301,
	MLX5_CMD_OP_DESTROY_EQ = 0x302,
	MLX5_CMD_OP_MODIFY_VPORT_STATE = 0x751,
	MLX5_CMD_OP_MODIFY_NIC_VPORT_CONTEXT = 0x755,
	MLX5_CMD_OP_ALLOC_PD = 0x800,
	MLX5_CMD_OP_DEALLOC_PD = 0x801,
	MLX5_CMD_OP_ALLOC_UAR = 0x802,
	MLX5_CMD_OP_DEALLOC_UAR = 0x803,
	MLX5_CMD_OP_ACCESS_REG = 0x805,
};

enum {
	MLX5_CMD_STAT_OK = 0x0,
	MLX5_CMD_STAT_INT_ERR = 0x1,
	MLX5_CMD_STAT_BAD_OP_ERR = 0x2,
	MLX5_CMD_STAT_BAD_PARAM_ERR = 0x3,
	MLX5_CMD_STAT_BAD_SYS_STATE_ERR = 0x4,
	MLX5_CMD_STAT_BAD_RES_ERR = 0x5,
	MLX5_CMD_STAT_RES_BUSY = 0x6,
	MLX5_CMD_STAT_LIM_ERR = 0x8,
	MLX5_CMD_STAT_BAD_RES_STATE_ERR = 0x9,
	MLX5_CMD_STAT_IX_ERR = 0xa,
	MLX5_CMD_STAT_NO_RES_ERR = 0xf,
	MLX5_CMD_STAT_BAD_INP_LEN_ERR = 0x50,
	MLX5_CMD_STAT_BAD_OUTP_LEN_ERR = 0x51,
	MLX5_CMD_STAT_BAD_QP_STATE_ERR = 0x10,
	MLX5_CMD_STAT_BAD_PKT_ERR = 0x30,
	MLX5_CMD_STAT_BAD_SIZE_OUTS_CQES_ERR = 0x40,
};

enum {
	MLX5_CAP_PORT_TYPE_IB = 0x0,
	MLX5_CAP_PORT_TYPE_ETH = 0x1,
};

enum {
	MLX5_REG_HOST_ENDIANNESS = 0x7004,
};

enum {
	MLX5_PAGES_CANT_GIVE = 0,
	MLX5_PAGES_GIVE = 1,
	MLX5_PAGES_TAKE = 2,
};

struct mlx5_ifc_mbox_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_mbox_in_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];
};

enum {
	MLX5_EQ_DOORBEL_OFFSET = 0x40,
};


struct mlx5_ifc_roce_cap_bits {
	uint8_t reserved_0[0x4];
	uint8_t sw_r_roce_src_udp_port[0x1];
	uint8_t fl_rc_qp_when_roce_disabled[0x1];
	uint8_t fl_rc_qp_when_roce_enabled[0x1];
	uint8_t reserved_at_7[0x17];
	uint8_t qp_ts_format[0x2];

	uint8_t reserved_at_20[0x7e0];
};

enum {
	MLX5_MULTI_PATH_FT_MAX_LEVEL = 64,
};

enum dr_devx_flow_dest_type {
	MLX5_FLOW_DEST_TYPE_VPORT = 0x0,
	MLX5_FLOW_DEST_TYPE_FT = 0x1,
	MLX5_FLOW_DEST_TYPE_TIR = 0x2,

	MLX5_FLOW_DEST_TYPE_COUNTER = 0x100,
};

enum {
	MLX5_FLOW_CONTEXT_ACTION_FWD_DEST = 0x4,
	MLX5_FLOW_CONTEXT_ACTION_COUNT = 0x8,
};


enum {
	MLX5_MKC_ACCESS_MODE_MTT = 0x1,
	MLX5_MKC_ACCESS_MODE_KLMS = 0x2,
};

struct mlx5_ifc_mkc_bits {
	uint8_t reserved_at_0[0x1];
	uint8_t free[0x1];
	uint8_t reserved_at_2[0x1];
	uint8_t access_mode_4_2[0x3];
	uint8_t reserved_at_6[0x7];
	uint8_t relaxed_ordering_write[0x1];
	uint8_t reserved_at_e[0x1];
	uint8_t small_fence_on_rdma_read_response[0x1];
	uint8_t umr_en[0x1];
	uint8_t a[0x1];
	uint8_t rw[0x1];
	uint8_t rr[0x1];
	uint8_t lw[0x1];
	uint8_t lr[0x1];
	uint8_t access_mode_1_0[0x2];
	uint8_t reserved_at_18[0x8];

	uint8_t qpn[0x18];
	uint8_t mkey_7_0[0x8];

	uint8_t reserved_at_40[0x20];

	uint8_t length64[0x1];
	uint8_t bsf_en[0x1];
	uint8_t sync_umr[0x1];
	uint8_t reserved_at_63[0x2];
	uint8_t expected_sigerr_count[0x1];
	uint8_t reserved_at_66[0x1];
	uint8_t en_rinval[0x1];
	uint8_t pd[0x18];

	uint8_t start_addr[0x40];

	uint8_t len[0x40];

	uint8_t bsf_octword_size[0x20];

	uint8_t reserved_at_120[0x80];

	uint8_t translations_octword_size[0x20];

	uint8_t reserved_at_1c0[0x19];
	uint8_t relaxed_ordering_read[0x1];
	uint8_t reserved_at_1d9[0x1];
	uint8_t log_page_size[0x5];

	uint8_t reserved_at_1e0[0x3];
	uint8_t crypto_en[0x2];
	uint8_t reserved_at_1e5[0x1b];
};

struct mlx5_ifc_create_mkey_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x8];
	uint8_t mkey_index[0x18];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_create_mkey_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x20];

	uint8_t pg_access[0x1];
	uint8_t mkey_umem_valid[0x1];
	uint8_t reserved_at_62[0x1e];

	struct mlx5_ifc_mkc_bits memory_key_mkey_entry;

	uint8_t reserved_at_280[0x80];

	uint8_t translations_octword_actual_size[0x20];

	uint8_t reserved_at_320[0x560];

	uint8_t klm_pas_mtt[0][0x20];
};

struct mlx5_ifc_destroy_mkey_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_destroy_mkey_in_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x8];
	uint8_t mkey_index[0x18];

	uint8_t reserved_at_60[0x20];
};


struct mlx5_ifc_modify_nic_vport_field_select_bits {
	uint8_t reserved_at_0[0x12];
	uint8_t affiliation[0x1];
	uint8_t reserved_at_13[0x1];
	uint8_t disable_uc_local_lb[0x1];
	uint8_t disable_mc_local_lb[0x1];
	uint8_t node_guid[0x1];
	uint8_t port_guid[0x1];
	uint8_t min_inline[0x1];
	uint8_t mtu[0x1];
	uint8_t change_event[0x1];
	uint8_t promisc[0x1];
	uint8_t permanent_address[0x1];
	uint8_t addresses_list[0x1];
	uint8_t roce_en[0x1];
	uint8_t reserved_at_1f[0x1];
};

struct mlx5_ifc_mac_address_layout_bits {
	uint8_t reserved_at_0[0x10];
	uint8_t mac_addr_47_32[0x10];

	uint8_t mac_addr_31_0[0x20];
};

struct mlx5_ifc_nic_vport_context_bits {
	uint8_t reserved_at_0[0x5];
	uint8_t min_wqe_inline_mode[0x3];
	uint8_t reserved_at_8[0x15];
	uint8_t disable_mc_local_lb[0x1];
	uint8_t disable_uc_local_lb[0x1];
	uint8_t roce_en[0x1];

	uint8_t arm_change_event[0x1];
	uint8_t reserved_at_21[0x1a];
	uint8_t event_on_mtu[0x1];
	uint8_t event_on_promisc_change[0x1];
	uint8_t event_on_vlan_change[0x1];
	uint8_t event_on_mc_address_change[0x1];
	uint8_t event_on_uc_address_change[0x1];

	uint8_t vhca_id_type[0x1];
	uint8_t reserved_at_41[0xb];
	uint8_t affiliation_criteria[0x4];
	uint8_t affiliated_vhca_id[0x10];

	uint8_t reserved_at_60[0xa0];

	uint8_t reserved_at_100[0x1];
	uint8_t sd_group[0x3];
	uint8_t reserved_at_104[0x1c];

	uint8_t reserved_at_120[0x10];
	uint8_t mtu[0x10];

	uint8_t system_image_guid[0x40];
	uint8_t port_guid[0x40];
	uint8_t node_guid[0x40];

	uint8_t reserved_at_200[0x140];
	uint8_t qkey_violation_counter[0x10];
	uint8_t reserved_at_350[0x430];

	uint8_t promisc_uc[0x1];
	uint8_t promisc_mc[0x1];
	uint8_t promisc_all[0x1];
	uint8_t reserved_at_783[0x2];
	uint8_t allowed_list_type[0x3];
	uint8_t reserved_at_788[0xc];
	uint8_t allowed_list_size[0xc];

	struct mlx5_ifc_mac_address_layout_bits permanent_address;

	uint8_t reserved_at_7e0[0x20];

	uint8_t current_uc_mac_address[][0x40];
};

struct mlx5_ifc_modify_nic_vport_context_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t other_vport[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t vport_number[0x10];

	struct mlx5_ifc_modify_nic_vport_field_select_bits field_select;

	uint8_t reserved_at_80[0x780];

	struct mlx5_ifc_nic_vport_context_bits nic_vport_context;
};

struct mlx5_ifc_enable_hca_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_enable_hca_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x20];
};

struct mlx5_ifc_disable_hca_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x20];
};

struct mlx5_ifc_disable_hca_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t embedded_cpu_function[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_modify_vport_state_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_modify_vport_state_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t other_vport[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t vport_number[0x10];

	uint8_t reserved_at_60[0x18];
	uint8_t admin_state[0x4];
	uint8_t reserved_at_7c[0x4];
};

enum {
	MLX5_VPORT_STATE_OP_MOD_VNIC_VPORT = 0x0,
	MLX5_VPORT_STATE_OP_MOD_ESW_VPORT = 0x1,
	MLX5_VPORT_STATE_OP_MOD_UPLINK = 0x2,
};

struct mlx5_ifc_query_issi_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x10];
	uint8_t current_issi[0x10];

	uint8_t reserved_at_60[0xa0];

	uint8_t reserved_at_100[76][0x8];
	uint8_t supported_issi_dw0[0x20];
};

struct mlx5_ifc_query_issi_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_set_issi_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_set_issi_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t current_issi[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_query_pages_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t embedded_cpu_function[0x01];
	uint8_t reserved_bits[0x0f];
	uint8_t function_id[0x10];

	uint8_t num_pages[0x20];
};

struct mlx5_ifc_query_pages_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_manage_pages_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t output_num_entries[0x20];

	uint8_t reserved_at_60[0x20];

	uint8_t pas[][0x40];
};

struct mlx5_ifc_manage_pages_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t embedded_cpu_function[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t function_id[0x10];

	uint8_t input_num_entries[0x20];

	uint8_t pas[][0x40];
};

enum {
	MLX5_TEARDOWN_HCA_OUT_FORCE_STATE_FAIL = 0x1,
};

struct mlx5_ifc_teardown_hca_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x3f];

	uint8_t state[0x1];
};

enum {
	MLX5_TEARDOWN_HCA_IN_PROFILE_GRACEFUL_CLOSE = 0x0,
	MLX5_TEARDOWN_HCA_IN_PROFILE_PREPARE_FAST_TEARDOWN = 0x2,
};

struct mlx5_ifc_teardown_hca_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t profile[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_init_hca_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_init_hca_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_access_register_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];

	uint8_t register_data[][0x20];
};

struct mlx5_ifc_access_register_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t register_id[0x10];

	uint8_t argument[0x20];

	uint8_t register_data[][0x20];
};


struct mlx5_ifc_cmd_hca_cap_bits {
	uint8_t access_other_hca_roce[0x1];
	uint8_t reserved_at_1[0x1e];
	uint8_t vhca_resource_manager[0x1];

	uint8_t hca_cap_2[0x1];
	uint8_t reserved_at_21[0xf];
	uint8_t vhca_id[0x10];

	uint8_t reserved_at_40[0x20];

	uint8_t reserved_at_60[0x2];
	uint8_t qp_data_in_order[0x1];
	uint8_t reserved_at_63[0x8];
	uint8_t log_dma_mmo_max_size[0x5];
	uint8_t reserved_at_70[0x10];

	uint8_t log_max_srq_sz[0x8];
	uint8_t log_max_qp_sz[0x8];
	uint8_t reserved_at_90[0x3];
	uint8_t isolate_vl_tc_new[0x1];
	uint8_t reserved_at_94[0x4];
	uint8_t prio_tag_required[0x1];
	uint8_t reserved_at_99[0x2];
	uint8_t log_max_qp[0x5];

	uint8_t reserved_at_a0[0xb];
	uint8_t log_max_srq[0x5];
	uint8_t reserved_at_b0[0x10];

	uint8_t reserved_at_c0[0x8];
	uint8_t log_max_cq_sz[0x8];
	uint8_t reserved_at_d0[0xb];
	uint8_t log_max_cq[0x5];

	uint8_t log_max_eq_sz[0x8];
	uint8_t relaxed_ordering_write[0x1];
	uint8_t reserved_at_e9[0x1];
	uint8_t log_max_mkey[0x6];
	uint8_t tunneled_atomic[0x1];
	uint8_t as_notify[0x1];
	uint8_t m_pci_port[0x1];
	uint8_t m_vhca_mk[0x1];
	uint8_t cmd_on_behalf[0x1];
	uint8_t device_emulation_manager[0x1];
	uint8_t terminate_scatter_list_mkey[0x1];
	uint8_t repeated_mkey[0x1];
	uint8_t dump_fill_mkey[0x1];
	uint8_t reserved_at_f9[0x3];
	uint8_t log_max_eq[0x4];

	uint8_t max_indirection[0x8];
	uint8_t fixed_buffer_size[0x1];
	uint8_t log_max_mrw_sz[0x7];
	uint8_t force_teardown[0x1];
	uint8_t fast_teardown[0x1];
	uint8_t log_max_bsf_list_size[0x6];
	uint8_t umr_extended_translation_offset[0x1];
	uint8_t null_mkey[0x1];
	uint8_t log_max_klm_list_size[0x6];

	uint8_t reserved_at_120[0x2];
	uint8_t qpc_extension[0x1];
	uint8_t reserved_at_123[0x7];
	uint8_t log_max_ra_req_dc[0x6];
	uint8_t reserved_at_130[0xa];
	uint8_t log_max_ra_res_dc[0x6];

	uint8_t reserved_at_140[0x7];
	uint8_t sig_crc64_xp10[0x1];
	uint8_t sig_crc32c[0x1];
	uint8_t reserved_at_149[0x1];
	uint8_t log_max_ra_req_qp[0x6];
	uint8_t reserved_at_150[0x1];
	uint8_t rts2rts_qp_udp_sport[0x1];
	uint8_t rts2rts_lag_tx_port_affinity[0x1];
	uint8_t dma_mmo_sq[0x1];
	uint8_t reserved_at_154[0x6];
	uint8_t log_max_ra_res_qp[0x6];

	uint8_t end_pad[0x1];
	uint8_t cc_query_allowed[0x1];
	uint8_t cc_modify_allowed[0x1];
	uint8_t start_pad[0x1];
	uint8_t cache_line_128byte[0x1];
	uint8_t gid_table_size_ro[0x1];
	uint8_t pkey_table_size_ro[0x1];
	uint8_t reserved_at_167[0x1];
	uint8_t rnr_nak_q_counters[0x1];
	uint8_t rts2rts_qp_counters_set_id[0x1];
	uint8_t rts2rts_qp_dscp[0x1];
	uint8_t reserved_at_16b[0x4];
	uint8_t qcam_reg[0x1];
	uint8_t gid_table_size[0x10];

	uint8_t out_of_seq_cnt[0x1];
	uint8_t vport_counters[0x1];
	uint8_t retransmission_q_counters[0x1];
	uint8_t debug[0x1];
	uint8_t modify_rq_counters_set_id[0x1];
	uint8_t rq_delay_drop[0x1];
	uint8_t max_qp_cnt[0xa];
	uint8_t pkey_table_size[0x10];

	uint8_t vport_group_manager[0x1];
	uint8_t vhca_group_manager[0x1];
	uint8_t ib_virt[0x1];
	uint8_t eth_virt[0x1];
	uint8_t vnic_env_queue_counters[0x1];
	uint8_t ets[0x1];
	uint8_t nic_flow_table[0x1];
	uint8_t eswitch_manager[0x1];
	uint8_t device_memory[0x1];
	uint8_t mcam_reg[0x1];
	uint8_t pcam_reg[0x1];
	uint8_t local_ca_ack_delay[0x5];
	uint8_t port_module_event[0x1];
	uint8_t enhanced_retransmission_q_counters[0x1];
	uint8_t port_checks[0x1];
	uint8_t pulse_gen_control[0x1];
	uint8_t disable_link_up_by_init_hca[0x1];
	uint8_t beacon_led[0x1];
	uint8_t port_type[0x2];
	uint8_t num_ports[0x8];

	uint8_t reserved_at_1c0[0x1];
	uint8_t pps[0x1];
	uint8_t pps_modify[0x1];
	uint8_t log_max_msg[0x5];
	uint8_t multi_path_xrc_rdma[0x1];
	uint8_t multi_path_dc_rdma[0x1];
	uint8_t multi_path_rc_rdma[0x1];
	uint8_t traffic_fast_control[0x1];
	uint8_t max_tc[0x4];
	uint8_t temp_warn_event[0x1];
	uint8_t dcbx[0x1];
	uint8_t general_notification_event[0x1];
	uint8_t multi_prio_sq[0x1];
	uint8_t afu_owner[0x1];
	uint8_t fpga[0x1];
	uint8_t rol_s[0x1];
	uint8_t rol_g[0x1];
	uint8_t ib_port_sniffer[0x1];
	uint8_t wol_s[0x1];
	uint8_t wol_g[0x1];
	uint8_t wol_a[0x1];
	uint8_t wol_b[0x1];
	uint8_t wol_m[0x1];
	uint8_t wol_u[0x1];
	uint8_t wol_p[0x1];

	uint8_t stat_rate_support[0x10];
	uint8_t sig_block_4048[0x1];
	uint8_t reserved_at_1f1[0xb];
	uint8_t cqe_version[0x4];

	uint8_t compact_address_vector[0x1];
	uint8_t eth_striding_wq[0x1];
	uint8_t reserved_at_202[0x1];
	uint8_t ipoib_enhanced_offloads[0x1];
	uint8_t ipoib_basic_offloads[0x1];
	uint8_t ib_striding_wq[0x1];
	uint8_t repeated_block_disabled[0x1];
	uint8_t umr_modify_entity_size_disabled[0x1];
	uint8_t umr_modify_atomic_disabled[0x1];
	uint8_t umr_indirect_mkey_disabled[0x1];
	uint8_t umr_fence[0x2];
	uint8_t dc_req_sctr_data_cqe[0x1];
	uint8_t dc_connect_qp[0x1];
	uint8_t dc_cnak_trace[0x1];
	uint8_t drain_sigerr[0x1];
	uint8_t cmdif_checksum[0x2];
	uint8_t sigerr_cqe[0x1];
	uint8_t reserved_at_213[0x1];
	uint8_t wq_signature[0x1];
	uint8_t sctr_data_cqe[0x1];
	uint8_t reserved_at_216[0x1];
	uint8_t sho[0x1];
	uint8_t tph[0x1];
	uint8_t rf[0x1];
	uint8_t dct[0x1];
	uint8_t qos[0x1];
	uint8_t eth_net_offloads[0x1];
	uint8_t roce[0x1];
	uint8_t atomic[0x1];
	uint8_t extended_retry_count[0x1];

	uint8_t cq_oi[0x1];
	uint8_t cq_resize[0x1];
	uint8_t cq_moderation[0x1];
	uint8_t cq_period_mode_modify[0x1];
	uint8_t cq_invalidate[0x1];
	uint8_t reserved_at_225[0x1];
	uint8_t cq_eq_remap[0x1];
	uint8_t pg[0x1];
	uint8_t block_lb_mc[0x1];
	uint8_t exponential_backoff[0x1];
	uint8_t scqe_break_moderation[0x1];
	uint8_t cq_period_start_from_cqe[0x1];
	uint8_t cd[0x1];
	uint8_t atm[0x1];
	uint8_t apm[0x1];
	uint8_t vector_calc[0x1];
	uint8_t umr_ptr_rlkey[0x1];
	uint8_t imaicl[0x1];
	uint8_t qp_packet_based[0x1];
	uint8_t reserved_at_233[0x1];
	uint8_t ipoib_enhanced_pkey_change[0x1];
	uint8_t initiator_src_dct_in_cqe[0x1];
	uint8_t qkv[0x1];
	uint8_t pkv[0x1];
	uint8_t set_deth_sqpn[0x1];
	uint8_t rts2rts_primary_sl[0x1];
	uint8_t initiator_src_dct[0x1];
	uint8_t dc_v2[0x1];
	uint8_t xrc[0x1];
	uint8_t ud[0x1];
	uint8_t uc[0x1];
	uint8_t rc[0x1];

	uint8_t uar_4k[0x1];
	uint8_t reserved_at_241[0x7];
	uint8_t fl_rc_qp_when_roce_disabled[0x1];
	uint8_t reserved_at_249[0x1];
	uint8_t uar_sz[0x6];
	uint8_t reserved_at_250[0x2];
	uint8_t umem_uid_0[0x1];
	uint8_t log_max_dc_cnak_qps[0x5];
	uint8_t log_pg_sz[0x8];

	uint8_t bf[0x1];
	uint8_t driver_version[0x1];
	uint8_t pad_tx_eth_packet[0x1];
	uint8_t query_driver_version[0x1];
	uint8_t max_qp_retry_freq[0x1];
	uint8_t qp_by_name[0x1];
	uint8_t mkey_by_name[0x1];
	uint8_t reserved_at_267[0x1];
	uint8_t suspend_qp_uc[0x1];
	uint8_t suspend_qp_ud[0x1];
	uint8_t suspend_qp_rc[0x1];
	uint8_t log_bf_reg_size[0x5];
	uint8_t reserved_at_270[0x6];
	uint8_t lag_dct[0x2];
	uint8_t lag_tx_port_affinity[0x1];
	uint8_t reserved_at_279[0x2];
	uint8_t lag_master[0x1];
	uint8_t num_lag_ports[0x4];

	uint8_t num_of_diagnostic_counters[0x10];
	uint8_t max_wqe_sz_sq[0x10];

	uint8_t reserved_at_2a0[0x10];
	uint8_t max_wqe_sz_rq[0x10];

	uint8_t max_flow_counter_31_16[0x10];
	uint8_t max_wqe_sz_sq_dc[0x10];

	uint8_t reserved_at_2e0[0x7];
	uint8_t max_qp_mcg[0x19];

	uint8_t mlnx_tag_ethertype[0x10];
	uint8_t reserved_at_310[0x8];
	uint8_t log_max_mcg[0x8];

	uint8_t reserved_at_320[0x3];
	uint8_t log_max_transport_domain[0x5];
	uint8_t reserved_at_328[0x3];
	uint8_t log_max_pd[0x5];
	uint8_t dp_ordering_ooo_all_ud[0x1];
	uint8_t dp_ordering_ooo_all_uc[0x1];
	uint8_t dp_ordering_ooo_all_xrc[0x1];
	uint8_t dp_ordering_ooo_all_dc[0x1];
	uint8_t dp_ordering_ooo_all_rc[0x1];
	uint8_t reserved_at_335[0x6];
	uint8_t log_max_xrcd[0x5];

	uint8_t nic_receive_steering_discard[0x1];
	uint8_t receive_discard_vport_down[0x1];
	uint8_t transmit_discard_vport_down[0x1];
	uint8_t eq_overrun_count[0x1];
	uint8_t nic_receive_steering_depth[0x1];
	uint8_t invalid_command_count[0x1];
	uint8_t quota_exceeded_count[0x1];
	uint8_t reserved_at_347[0x1];
	uint8_t log_max_flow_counter_bulk[0x8];
	uint8_t max_flow_counter_15_0[0x10];

	uint8_t modify_tis[0x1];
	uint8_t reserved_at_361[0x2];
	uint8_t log_max_rq[0x5];
	uint8_t reserved_at_368[0x3];
	uint8_t log_max_sq[0x5];
	uint8_t reserved_at_370[0x3];
	uint8_t log_max_tir[0x5];
	uint8_t reserved_at_378[0x3];
	uint8_t log_max_tis[0x5];

	uint8_t basic_cyclic_rcv_wqe[0x1];
	uint8_t reserved_at_381[0x2];
	uint8_t log_max_rmp[0x5];
	uint8_t reserved_at_388[0x3];
	uint8_t log_max_rqt[0x5];
	uint8_t reserved_at_390[0x3];
	uint8_t log_max_rqt_size[0x5];
	uint8_t reserved_at_398[0x3];
	uint8_t log_max_tis_per_sq[0x5];

	uint8_t ext_stride_num_range[0x1];
	uint8_t reserved_at_3a1[0x2];
	uint8_t log_max_stride_sz_rq[0x5];
	uint8_t reserved_at_3a8[0x3];
	uint8_t log_min_stride_sz_rq[0x5];
	uint8_t reserved_at_3b0[0x3];
	uint8_t log_max_stride_sz_sq[0x5];
	uint8_t reserved_at_3b8[0x3];
	uint8_t log_min_stride_sz_sq[0x5];

	uint8_t hairpin[0x1];
	uint8_t reserved_at_3c1[0x2];
	uint8_t log_max_hairpin_queues[0x5];
	uint8_t reserved_at_3c8[0x3];
	uint8_t log_max_hairpin_wq_data_sz[0x5];
	uint8_t reserved_at_3d0[0x3];
	uint8_t log_max_hairpin_num_packets[0x5];
	uint8_t reserved_at_3d8[0x3];
	uint8_t log_max_wq_sz[0x5];

	uint8_t nic_vport_change_event[0x1];
	uint8_t disable_local_lb_uc[0x1];
	uint8_t disable_local_lb_mc[0x1];
	uint8_t log_min_hairpin_wq_data_sz[0x5];
	uint8_t reserved_at_3e8[0x3];
	uint8_t log_max_vlan_list[0x5];
	uint8_t reserved_at_3f0[0x1];
	uint8_t aes_xts_single_block_le_tweak[0x1];
	uint8_t aes_xts_multi_block_be_tweak[0x1];
	uint8_t log_max_current_mc_list[0x5];
	uint8_t reserved_at_3f8[0x3];
	uint8_t log_max_current_uc_list[0x5];

	uint8_t general_obj_types[0x40];

	uint8_t sq_ts_format[0x2];
	uint8_t rq_ts_format[0x2];
	uint8_t steering_format_version[0x4];
	uint8_t create_qp_start_hint[0x18];

	uint8_t reserved_at_460[0x9];
	uint8_t crypto[0x1];
	uint8_t reserved_at_46a[0x6];
	uint8_t max_num_eqs[0x10];

	uint8_t sigerr_domain_and_sig_type[0x1];
	uint8_t reserved_at_481[0x2];
	uint8_t log_max_l2_table[0x5];
	uint8_t reserved_at_488[0x8];
	uint8_t log_uar_page_sz[0x10];

	uint8_t reserved_at_4a0[0x20];

	uint8_t device_frequency_mhz[0x20];

	uint8_t device_frequency_khz[0x20];

	uint8_t capi[0x1];
	uint8_t create_pec[0x1];
	uint8_t nvmf_target_offload[0x1];
	uint8_t capi_invalidate[0x1];
	uint8_t reserved_at_504[0x17];
	uint8_t log_max_pasid[0x5];

	uint8_t num_of_uars_per_page[0x20];

	uint8_t flex_parser_protocols[0x20];

	uint8_t reserved_at_560[0x10];
	uint8_t flex_parser_header_modify[0x1];
	uint8_t reserved_at_571[0x2];
	uint8_t log_max_guaranteed_connections[0x5];
	uint8_t reserved_at_578[0x3];
	uint8_t log_max_dct_connections[0x5];

	uint8_t log_max_atomic_size_qp[0x8];
	uint8_t reserved_at_588[0x10];
	uint8_t log_max_atomic_size_dc[0x8];

	uint8_t reserved_at_5a0[0x1c];
	uint8_t mini_cqe_resp_stride_index[0x1];
	uint8_t cqe_128_always[0x1];
	uint8_t cqe_compression_128b[0x1];
	uint8_t cqe_compression[0x1];

	uint8_t cqe_compression_timeout[0x10];
	uint8_t cqe_compression_max_num[0x10];

	uint8_t reserved_at_5e0[0x8];
	uint8_t flex_parser_id_gtpu_dw_0[0x4];
	uint8_t log_max_tm_offloaded_op_size[0x4];
	uint8_t tag_matching[0x1];
	uint8_t rndv_offload_rc[0x1];
	uint8_t rndv_offload_dc[0x1];
	uint8_t log_tag_matching_list_sz[0x5];
	uint8_t reserved_at_5f8[0x3];
	uint8_t log_max_xrq[0x5];

	uint8_t affiliate_nic_vport_criteria[0x8];
	uint8_t native_port_num[0x8];
	uint8_t num_vhca_ports[0x8];
	uint8_t flex_parser_id_gtpu_teid[0x4];
	uint8_t reserved_at_61c[0x1];
	uint8_t trusted_vnic_vhca[0x1];
	uint8_t sw_owner_id[0x1];
	uint8_t reserve_not_to_use[0x1];
	uint8_t reserved_at_620[0x60];
	uint8_t sf[0x1];
	uint8_t reserved_at_682[0x43];
	uint8_t flex_parser_id_geneve_opt_0[0x4];
	uint8_t flex_parser_id_icmp_dw1[0x4];
	uint8_t flex_parser_id_icmp_dw0[0x4];
	uint8_t flex_parser_id_icmpv6_dw1[0x4];
	uint8_t flex_parser_id_icmpv6_dw0[0x4];
	uint8_t flex_parser_id_outer_first_mpls_over_gre[0x4];
	uint8_t flex_parser_id_outer_first_mpls_over_udp_label[0x4];

	uint8_t reserved_at_6e0[0x20];

	uint8_t flex_parser_id_gtpu_dw_2[0x4];
	uint8_t flex_parser_id_gtpu_first_ext_dw_0[0x4];
	uint8_t reserved_at_708[0x18];

	uint8_t reserved_at_720[0x20];

	uint8_t reserved_at_740[0x8];
	uint8_t dma_mmo_qp[0x1];
	uint8_t reserved_at_749[0x9];
	uint8_t data_direct[0x1];
	uint8_t reserved_at_753[0xd];

	uint8_t reserved_at_760[0x3];
	uint8_t log_max_num_header_modify_argument[0x5];
	uint8_t reserved_at_768[0x4];
	uint8_t log_header_modify_argument_granularity[0x4];
	uint8_t reserved_at_770[0x3];
	uint8_t log_header_modify_argument_max_alloc[0x5];
	uint8_t reserved_at_778[0x8];

	uint8_t reserved_at_780[0x40];

	uint8_t match_definer_format_supported[0x40];
};

struct mlx5_ifc_cmd_hca_cap_2_bits {
	uint8_t reserved_at_0[0x80];

	uint8_t migratable[0x1];
	uint8_t reserved_at_81[0x7];
	uint8_t dp_ordering_force[0x1];
	uint8_t reserved_at_89[0x9];
	uint8_t query_vuid[0x1];
	uint8_t reserved_at_93[0x5];
	uint8_t umr_log_entity_size_5[0x1];
	uint8_t reserved_at_99[0x7];

	uint8_t max_reformat_insert_size[0x8];
	uint8_t max_reformat_insert_offset[0x8];
	uint8_t max_reformat_remove_size[0x8];
	uint8_t max_reformat_remove_offset[0x8];

	uint8_t reserved_at_c0[0x8];
	uint8_t migration_multi_load[0x1];
	uint8_t migration_tracking_state[0x1];
	uint8_t multiplane_qp_ud[0x1];
	uint8_t reserved_at_cb[0x5];
	uint8_t migration_in_chunks[0x1];
	uint8_t reserved_at_d1[0x1];
	uint8_t sf_eq_usage[0x1];
	uint8_t reserved_at_d3[0x5];
	uint8_t multiplane[0x1];
	uint8_t reserved_at_d9[0x7];

	uint8_t	cross_vhca_object_to_object_supported[0x20];

	uint8_t	allowed_object_for_other_vhca_access[0x40];

	uint8_t	reserved_at_140[0x60];

	uint8_t flow_table_type_2_type[0x8];
	uint8_t reserved_at_1a8[0x2];
	uint8_t format_select_dw_8_6_ext[0x1];
	uint8_t log_min_mkey_entity_size[0x5];
	uint8_t reserved_at_1b0[0x10];

	uint8_t general_obj_types_127_64[0x40];
	uint8_t reserved_at_200[0x20];

	uint8_t reserved_at_220[0x1];
	uint8_t sw_vhca_id_valid[0x1];
	uint8_t sw_vhca_id[0xe];
	uint8_t reserved_at_230[0x10];

	uint8_t reserved_at_240[0xb];
	uint8_t ts_cqe_metadata_size2wqe_counter[0x5];
	uint8_t reserved_at_250[0x10];

	uint8_t reserved_at_260[0x20];

	uint8_t format_select_dw_gtpu_dw_0[0x8];
	uint8_t format_select_dw_gtpu_dw_1[0x8];
	uint8_t format_select_dw_gtpu_dw_2[0x8];
	uint8_t format_select_dw_gtpu_first_ext_dw_0[0x8];

	uint8_t generate_wqe_type[0x20];

	uint8_t reserved_at_2c0[0xc0];

	uint8_t reserved_at_380[0xb];
	uint8_t min_mkey_log_entity_size_fixed_buffer[0x5];
	uint8_t ec_vf_vport_base[0x10];

	uint8_t reserved_at_3a0[0xa];
	uint8_t max_mkey_log_entity_size_mtt[0x6];
	uint8_t max_rqt_vhca_id[0x10];

	uint8_t reserved_at_3c0[0x20];

	uint8_t reserved_at_3e0[0x10];
	uint8_t pcc_ifa2[0x1];
	uint8_t reserved_at_3f1[0xf];

	uint8_t reserved_at_400[0x1];
	uint8_t min_mkey_log_entity_size_fixed_buffer_valid[0x1];
	uint8_t reserved_at_402[0xe];
	uint8_t return_reg_id[0x10];

	uint8_t reserved_at_420[0x1c];
	uint8_t flow_table_hash_type[0x4];

	uint8_t reserved_at_440[0x8];
	uint8_t max_num_eqs_24b[0x18];

	uint8_t reserved_at_460[0x160];

	uint8_t query_adjacent_functions_id[0x1];
	uint8_t ingress_egress_esw_vport_connect[0x1];
	uint8_t function_id_type_vhca_id[0x1];
	uint8_t reserved_at_5c3[0xd];
	uint8_t delegate_vhca_management_profiles[0x10];

	uint8_t delegated_vhca_max[0x10];
	uint8_t delegate_vhca_max[0x10];

	uint8_t reserved_at_600[0x200];
};

union mlx5_ifc_hca_cap_union_bits {
	struct mlx5_ifc_cmd_hca_cap_bits cmd_hca_cap;
	struct mlx5_ifc_roce_cap_bits roce_caps;
	uint8_t reserved_at_0[0x8000];
};

struct mlx5_ifc_modify_nic_vport_context_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_query_hca_cap_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];

	union mlx5_ifc_hca_cap_union_bits capability;
};


struct mlx5_ifc_query_hca_cap_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t other_function[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_set_hca_cap_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_set_hca_cap_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t other_function[0x1];
	uint8_t reserved_at_41[0xf];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];

	union mlx5_ifc_hca_cap_union_bits capability;
};

struct mlx5_ifc_alloc_uar_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x8];
	uint8_t uar[0x18];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_alloc_uar_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_dealloc_uar_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_dealloc_uar_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x8];
	uint8_t uar[0x18];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_eqc_bits {
	uint8_t status[0x4];
	uint8_t reserved_at_4[0x9];
	uint8_t ec[0x1];
	uint8_t oi[0x1];
	uint8_t reserved_at_f[0x5];
	uint8_t st[0x4];
	uint8_t reserved_at_18[0x8];

	uint8_t reserved_at_20[0x20];

	uint8_t reserved_at_40[0x14];
	uint8_t page_offset[0x6];
	uint8_t reserved_at_5a[0x6];

	uint8_t reserved_at_60[0x3];
	uint8_t log_eq_size[0x5];
	uint8_t uar_page[0x18];

	uint8_t reserved_at_80[0x20];

	uint8_t reserved_at_a0[0x18];
	uint8_t intr[0x8];

	uint8_t reserved_at_c0[0x3];
	uint8_t log_page_size[0x5];
	uint8_t reserved_at_c8[0x18];

	uint8_t reserved_at_e0[0x60];

	uint8_t reserved_at_140[0x8];
	uint8_t consumer_counter[0x18];

	uint8_t reserved_at_160[0x8];
	uint8_t producer_counter[0x18];

	uint8_t reserved_at_180[0x80];
};

struct mlx5_ifc_create_eq_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x18];
	uint8_t eq_number[0x8];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_create_eq_in_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];

	struct mlx5_ifc_eqc_bits eq_context_entry;

	uint8_t reserved_at_280[0x40];

	uint8_t event_bitmask[4][0x40];

	uint8_t reserved_at_3c0[0x4c0];

	uint8_t pas[][0x40];
};

struct mlx5_ifc_destroy_eq_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_destroy_eq_in_bits {
	uint8_t opcode[0x10];
	uint8_t reserved_at_10[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x18];
	uint8_t eq_number[0x8];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_alloc_pd_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x8];
	uint8_t pd[0x18];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_alloc_pd_in_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_dealloc_pd_out_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x40];
};

struct mlx5_ifc_dealloc_pd_in_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x8];
	uint8_t pd[0x18];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_function_vhca_rid_info_reg_bits {
	uint8_t host_number[0x8];
	uint8_t host_pci_device_function[0x8];
	uint8_t host_pci_bus[0x8];
	uint8_t reserved_at_18[0x3];
	uint8_t pci_bus_assigned[0x1];
	uint8_t function_type[0x4];

	uint8_t parent_pci_device_function[0x8];
	uint8_t parent_pci_bus[0x8];
	uint8_t vhca_id[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t function_id[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_delegated_function_vhca_rid_info_bits {
	struct mlx5_ifc_function_vhca_rid_info_reg_bits function_vhca_rid_info;

	uint8_t reserved_at_80[0x18];
	uint8_t manage_profile[0x8];

	uint8_t reserved_at_a0[0x60];
};

struct mlx5_ifc_adjacent_function_vhca_rid_info_reg_bits {
	struct mlx5_ifc_function_vhca_rid_info_reg_bits function_vhca_rid_info;

	uint8_t reserved_at_80[0x80];
};

struct mlx5_ifc_query_adjacent_functions_id_input_reg_bits {
	uint8_t opcode[0x10];
	uint8_t uid[0x10];

	uint8_t reserved_at_20[0x10];
	uint8_t op_mod[0x10];

	uint8_t reserved_at_40[0x10];
	uint8_t function_type[0x10];

	uint8_t reserved_at_60[0x20];
};

struct mlx5_ifc_query_adjacent_functions_id_output_reg_bits {
	uint8_t status[0x8];
	uint8_t reserved_at_8[0x18];

	uint8_t syndrome[0x20];

	uint8_t reserved_at_40[0x20];

	uint8_t reserved_at_60[0x10];
	uint8_t functions_count[0x10];

	uint8_t reserved_at_80[0x80];

	struct mlx5_ifc_adjacent_function_vhca_rid_info_reg_bits
		adjacent_function_vhca_rid_info[0];
};

struct mlx5_ifc_delegate_vhca_management_out_bits {
	uint8_t         status[0x8];
	uint8_t         reserved_at_8[0x18];

	uint8_t         syndrome[0x20];

	uint8_t         reserved_at_40[0x40];
};

struct mlx5_ifc_delegate_vhca_management_in_bits {
	uint8_t         opcode[0x10];
	uint8_t         uid[0x10];

	uint8_t         reserved_at_20[0x10];
	uint8_t         op_mod[0x10];

	uint8_t         managed_vhca_id[0x10];
	uint8_t         dest_vhca_id[0x10];

	uint8_t         reserved_at_60[0x18];
	uint8_t         management_profile[0x8];
};

#endif /* IFC_H */
