// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef __EQ_H__
#define __EQ_H__

#include <linux/types.h>
#include <stddef.h>
#include <stdint.h>

#include "abi.h"
#include "vfio_mlx5.h"

#define __packed_aligned256 __packed_aligned(256)

struct __packed_aligned256 mlx5_eq {
	unsigned int vecidx;
	uint8_t eqn;
	uint64_t iova_size;
	uint32_t nent;
	uint32_t cons_index;
	/* used as ptrs */
	uint64_t iova __ptr_align;
	uint32_t uarn __ptr_align;
	/* add new fields here, struct is padded to 256 bytes */

	/* no alignment needed here, dynamic fields not protected by ABI
	 * RESUME: update on resume
	 */
	__be32 *doorbell;
	void *vaddr;
};

/* ABI break checks */
_ABI_sz_assert(1.0, struct mlx5_eq, 256);
_ABI_offset_assert(1.0, struct mlx5_eq, uarn, 32);

int mlx5_vfio_create_async_eq(struct vfio_mlx5_dev *dev);
void mlx5_vfio_destroy_async_eqs(struct vfio_mlx5_dev *dev);
int mlx5_vfio_async_events_process(struct vfio_mlx5_dev *dev);
void *mlx5_dev_eq_doorbell_addr(const struct vfio_mlx5_dev *dev);

#endif /* __EQ_H__ */
