// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
// SPDX-License-Identifier: BSD-3-Clause

#ifndef MLX5_VFIO_ABI_H
#define MLX5_VFIO_ABI_H

#define MLX5_MAGIC_VALUE 0x4d4c585f /* MLX5_ */

#define __packed __attribute__((__packed__))
#define __aligned(x) __attribute__((__aligned__(x)))
#define __packed_aligned(x) __attribute__((__packed__, __aligned__(x)))
#define __ptr_align __attribute__((__aligned__(sizeof(void *))))
#define __packed_aligned4k __packed_aligned(MLX5_ADAPTER_PAGE_SIZE)
#define __packed_aligned64 __packed_aligned(64)

#define _ABI_sz_assert(version, type, size)               \
	_Static_assert(sizeof(type) == size,              \
		       "ABI break v" #version " : " #type \
		       " size must be " #size)

#define _ABI_offset_assert(version, type, field, offset)             \
	_Static_assert(offsetof(type, field) == offset,              \
		       "ABI break v" #version " : " #type "." #field \
		       " offset must be " #offset)

#endif /* MLX5_VFIO_ABI_H */
