/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2023-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef DOCA_MIRROR_H
#define DOCA_MIRROR_H

#define DOCA_MIRRORS_MAX_TARGETS 16

#include "dpdk-offload-doca.h"

struct doca_mirror_ctx;
struct doca_mirrors;
struct netdev;
struct ovs_doca_flow_actions;

struct ovs_mirror_target {
    struct ovs_doca_flow_actions actions;
    struct ovs_doca_flow_actions actions_mask;
    struct doca_flow_fwd fwd;
};

struct ovs_mirror_set {
    int nr_targets;
    struct ovs_mirror_target *target;
};

struct doca_mirrors *
doca_mirrors_create(struct netdev *netdev);

void
doca_mirrors_destroy(struct doca_mirrors *doca_mirrors);

struct doca_mirror_ctx *
doca_mirror_ctx_create(struct doca_mirrors *doca_mirrors,
                       struct ovs_mirror_set *mirror_set,
                       struct ovs_doca_flow_actions *actions,
                       struct ovs_doca_flow_actions *actions_mask,
                       struct doca_flow_fwd *fwd);

void
doca_mirror_ctx_destroy(struct doca_mirror_ctx *mirror_ctx);

#endif /* DOCA_MIRROR_H */
