/* SPDX-License-Identifier: GPL-2.0 OR Linux-OpenIB */
/* Copyright (c) 2025 NVIDIA Corporation & Affiliates */

#ifndef MLX5_DEVM_DRIVER_PARAMS_H
#define MLX5_DEVM_DRIVER_PARAMS_H

enum mlx5_devm_param_id {
	MLX5_DEVM_PARAM_ID_BASE = MLXDEVM_PARAM_GENERIC_ID_MAX,
	MLX5_DEVM_PARAM_ID_CPU_AFFINITY,
	MLX5_DEVM_PARAM_ID_CMPL_EQ_DEPTH,
	MLX5_DEVM_PARAM_ID_ASYNC_EQ_DEPTH,
	MLX5_DEVM_PARAM_ID_DISABLE_ROCE,
	MLX5_DEVM_PARAM_ID_DISABLE_FC,
	MLX5_DEVM_PARAM_ID_DISABLE_NETDEV,
	MLX5_DEVM_PARAM_ID_MAX_CMPL_EQS,
	MLX5_DEVM_PARAM_ID_ESW_MULTIPORT,
	MLX5_DEVM_PARAM_ID_ESW_PORT_METADATA,
	MLX5_DEVM_PARAM_ID_FLOW_STEERING_MODE,
	MLX5_DEVM_PARAM_ID_CT_MAX_OFFLOADED_CONNS,
	MLX5_DEVM_PARAM_ID_ESW_LARGE_GROUP_NUM,
	MLX5_DEVM_PARAM_ID_HAIRPIN_NUM_QUEUES,
	MLX5_DEVM_PARAM_ID_HAIRPIN_QUEUE_SIZE,
};

enum mlx5_devm_trap_driver_id {
	MLX5_DEVM_TRAP_DRIVER_ID_BASE= MLXDEVM_TRAP_GENERIC_ID_MAX,
	MLX5_DEVM_TRAP_DRIVER_ID_INGRESS_VLAN_FILTER,
	MLX5_DEVM_TRAP_DRIVER_ID_DMAC_FILTER,
};

#endif
