/* Copyright (c) 2008, 2009, 2010, 2011, 2012, 2014 Nicira, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef VSWITCHD_BRIDGE_H
#define VSWITCHD_BRIDGE_H 1

#include <stdbool.h>

#include "openvswitch/types.h"

struct simap;

void bridge_init(const char *remote);
void bridge_exit(bool delete_datapath);

void bridge_run(void);
void bridge_wait(void);

void bridge_get_memory_usage(struct simap *usage);

struct ofproto *
bridge_get_ofproto_by_name(const char *name);

void
bridge_ofproto_deny_flush(bool deny);

void
bridge_remove_ctrl_mgmt_snoop(bool remove_mgmt);

void
bridge_mgmt_rename(bool upgrading);

void
bridge_remotes_disable(bool disable);

void
bridge_traverse_ports(void (*cb)(const char *, ofp_port_t, void *), void *);

#endif /* bridge.h */
