/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2014-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#ifndef NETDEV_DOCA_H
#define NETDEV_DOCA_H

#include <config.h>

#include "netdev-doca-ext.h"
#include "openvswitch/compiler.h"
#include "smap.h"

struct netdev_class;
struct dp_packet;
struct netdev;

#ifdef DPDK_NETDEV

#include <rte_flow.h>
#include <rte_pci.h>

void netdev_doca_register(const struct smap *);

bool netdev_doca_flow_api_supported(struct netdev *);

int
netdev_doca_rte_flow_destroy(struct netdev *netdev,
                             struct rte_flow *rte_flow,
                             struct rte_flow_error *error,
                             bool esw_port_id);
struct rte_flow *
netdev_doca_rte_flow_create(struct netdev *netdev,
                            const struct rte_flow_attr *attr,
                            const struct rte_flow_item *items,
                            const struct rte_flow_action *actions,
                            struct rte_flow_error *error);
int
netdev_doca_rte_flow_query_count(struct netdev *netdev,
                                 struct rte_flow *rte_flow,
                                 struct rte_flow_query_count *query,
                                 struct rte_flow_error *error);
int
netdev_doca_get_port_id(const struct netdev *netdev);
bool
netdev_doca_parse_dpdk_devargs_pci(const char *devargs, struct rte_pci_addr *rte_pci);

static inline void
netdev_doca_set_error(struct rte_flow_error *error, enum rte_flow_error_type type)
{
    if (!error) {
        return;
    }
    error->type = type;
    error->cause = NULL;
    error->message = NULL;
}

bool is_doca_class(const struct netdev_class *class);
void netdev_doca_dev_lock(struct netdev *netdev);
void netdev_doca_dev_unlock(struct netdev *netdev);

#endif

#endif /* netdev-doca.h */
