/*
 * Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef DPCTL_EXT_H
#define DPCTL_EXT_H 1

#include <stdbool.h>

#include "compiler.h"

struct skiplist_node;
struct dpif;
struct dpctl_params;
struct skiplist;

struct sorted_flow_node {
    char *key;
    char *flow_desc;
    int pmd_id;
};

int
dpctl_sorted_flow_cmp(const void *a, const void *b,
                 const void *conf OVS_UNUSED);

void
dpctl_sorted_flow_free(void *_node);

void
dpctl_sorted_flow_insert(const char *sort_list,
                         struct skiplist *sl,
                         int pmd_id,
                         const char *flow_desc);

int
dpctl_validate_sort_list(const char *s);

int
dpctl_offload_stats_clear(int argc, const char *argv[],
                          struct dpctl_params *dpctl_p);

#endif /* dpctl-ext.h */
