/*
 * Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef CONCURRENT_ARRAY_H
#define CONCURRENT_ARRAY_H

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

/*
 * Concurrent array
 * ================
 *
 * A dynamic array that supports safe lockless reads and
 * reasonably fast writes.
 *
 * Thread-safety
 * =============
 *
 * APIs are thread safe.
 *
 */

#define CONCURRENT_ARRAY_SLAB_SIZE 1024

struct concurrent_array;

struct concurrent_array *concurrent_array_create(void);
void concurrent_array_destroy(struct concurrent_array *c);

void concurrent_array_set(struct concurrent_array *c, uint32_t id, void *data);
void *concurrent_array_get(struct concurrent_array *c, uint32_t id);

#endif  /* CONCURRENT_ARRAY_H */
