#! /bin/sh
./utilities/install-git-hooks.sh
release=`utilities/git-desc.sh`
[ -f "VERSION" ] && version=`cat VERSION`
autoreconf --install --force || exit
[ -z "$version" ] && version=`autom4te -l Autoconf -t 'AC_INIT:$2' configure.ac`
echo "${version}-${release}"
# debian package cannot be built after running configure as dpkg-buildpackage
# will fail if the source directory is not clean so generate changelog here.
sed -e "s/@VERSION@/$version/g" -e "s/@RELEASE@/$release/g" \
    debian/changelog.in > debian/changelog
# also prepare the spec rpm without the need to run configure.
release=`echo $release | tr - _`
sed -e "s/@VERSION@/$version/g" -e "s/@RELEASE@/$release/g" \
    rhel/doca-openvswitch.spec.in > rhel/doca-openvswitch.spec

echo "Bootstrap done, you might want to execute ./build.sh --install-deps"
