#!/bin/bash
#
# SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
# Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction,
# disclosure or distribution of this material and related documentation
# without an express license agreement from NVIDIA CORPORATION or
# its affiliates is strictly prohibited.
#
# Usage:
# Run boot.sh and configure scripts.
# Run this script to compile instead of 'make'.

cov_bin_dir="/auto/sw_tools/Commercial/Synopsys/Coverity/latest/linux_x86_64/bin"
# Some older paths documented here.
#cov_bin_dir="/.autodirect/app/Coverity/cov-analysis-linux64-7.0.1/bin"
#cov_bin_dir="/.autodirect/app/Coverity/cov-analysis-linux64-7.6.0/bin"
PATH="$cov_bin_dir:$PATH"
ncores=`nproc`

function call() {
    echo
    echo $@
    echo
    $@
}

[ -e emit ] && echo "WARNING: You may need to remove directory 'emit'."
[ -e output ] && echo "WARNING: You may need to remove directory 'output'."
# Synopsys.
[ -e idir ] && echo "WARNING: You may need to remove directory 'idir'."
sleep 3

# Synopsis wrapper commands are very slow.
USE_SYNOPSIS_COVERITY_CMD=0
USE_SYNOPSIS_COVERITY_SCAN=0
BUILD_CMD="make -j$ncores -s"

if [ "$USE_SYNOPSIS_COVERITY_CMD" == 1 ] && [ -e $cov_bin_dir/coverity ]; then
    # Synopsys.
    if [ "$USE_SYNOPSIS_COVERITY_SCAN" == 1]; then
        # scan wraps capture and analyze.
        call coverity scan --local . -- $BUILD_CMD
    else
        call coverity capture -- $BUILD_CMD || exit 1
        call coverity analyze
    fi
else
    # To run manually call the following commands.
    call cov-build --dir . $BUILD_CMD || exit 1
    call cov-analyze --dir . --all \
                     -co STACK_USE:max_single_base_use_bytes:65536 \
                     -co STACK_USE:max_total_use_bytes:65536 \
                     --parse-warnings-config ./.ngci/coverity/parse_warnings.conf || exit 1
    call cov-format-errors --dir . --text-output-style oneline > ./output/report.txt
    call cov-format-errors --dir . --html-output ./output/report
    echo
    echo "text report in ./output/report.txt"
    echo "html report in ./output/report/index.html"
fi
