BUILT_SOURCES += \
    include/odp-netlink.h \
    include/odp-netlink-macros.h

# we use DPDK_NETDEV as we use dpif-doca for dpdk as well
if DPDK_NETDEV
BUILT_SOURCES += \
	include/dpif-doca-tcpdump-hooks.h
endif

include/odp-netlink.h: include/linux/openvswitch.h \
                       build-aux/extract-odp-netlink-h
	$(AM_V_GEN)sed -f $(srcdir)/build-aux/extract-odp-netlink-h < $< > $@

include/odp-netlink-macros.h: include/odp-netlink.h \
                              build-aux/extract-odp-netlink-macros-h
	$(AM_V_GEN)sh -f $(srcdir)/build-aux/extract-odp-netlink-macros-h $< > $@

if DPDK_NETDEV
include/dpif-doca-tcpdump-hooks.h: $(srcdir)/build-aux/dpif-doca-tcpdump-gen-hooks \
                                   $(srcdir)/build-aux/dpif-doca-tcpdump-hooks
	$(AM_V_GEN)$(run_python) $(srcdir)/build-aux/dpif-doca-tcpdump-gen-hooks \
	--h $(srcdir)/build-aux/dpif-doca-tcpdump-hooks $< > $@
endif

CLEANFILES += \
    include/odp-netlink.h \
    include/odp-netlink-macros.h

if DPDK_NETDEV
CLEANFILES += \
	include/dpif-doca-tcpdump-hooks.h
endif

include include/openflow/automake.mk
include include/openvswitch/automake.mk
include include/sparse/automake.mk
include include/windows/automake.mk
include include/linux/automake.mk
