#!/bin/bash

function print_usage {
cat <<HELP_USAGE
Usage: run DOCA telemetry service

$program_name [Optional Parameters]

  Optional Parameters:
      --ssh FILE      Append ssh key to FILE
      --help          Show this message and exit

HELP_USAGE
  exit 2
}

function set_ssh_key {
    local sshfile="$1"
    local base=$( dirname "$sshfile" )
    if [[ ! -d "$base" ]]; then
        echo "Error: invalid path '$base'"
        return
    elif [[ ! -f "$sshfile"  ]]; then
        touch "$sshfile"
        chmod 600 "$sshfile"
    elif [[ ! -r "$sshfile" ]]; then
        echo "Error: '$sshfile' is not readable"
        return
    fi
    mkdir -p $HOME/.ssh
    ssh-keygen -q -N "" -f $HOME/.ssh/id_rsa
    cat $HOME/.ssh/id_rsa.pub >> "$sshfile"
}

while case "$1" in
        --ssh)          set_ssh_key "${2}"; shift;;
        --help)         print_usage;;
        -?*)            echo "Unknown option ${1}"; print_usage;;
        *)              false;;
      esac
do
  shift
done

supervisord --configuration=/config/supervisord.conf