#!/bin/bash

# this script will be the first to run when the container starts

function get_value_by_key {
config_file=/config/launch_ibdiagnet_config.ini
key=$1
awk -v pattern="${key}=" '$0~pattern { print $1 }' $config_file | awk -F= '// { print $2 }'
}

# removing these files is vital when running a new container with different schema.
# by removing these files we avoid appending new data to the same binary files,
# that the previous container created
data_dir=`get_value_by_key "data_dir"`
set -x
rm -f $data_dir/last_files_written*.info
