#!/bin/bash

# This script does nothing without arguments.
# With arguments given:
# - If dest_ip is set it enables forward.exp and replaces destenation IP of Fluent receiver.
# - If dest_port is set it redefines destenation Port of Fluent receiver.
# - If data_set is set to "morpheus" the predifined fset/cset will be used.
#            By default export will run without fset/cset filtering

dest_ip=""
dest_port=""
data_set=""


function print_help {
    echo "-i=, --dest_ip=       Fluent export forward destination ip   (required)"
    echo "-p=, --dest_port=     Fluent export forward destination port (required)"
    echo "-d,  --data-set       Use predifined filters for datasets. Available sets: morpheus"
    echo "-h,  --help           print this message"
}

# parse arguments:
for i in "$@"
do
case $i in
    -h|--help)
    print_help
    exit 0
    ;;
    -p=*|--dest_port=*)
    dest_port="${i#*=}"
    shift # past argument=value
    ;;
    -i=*|--dest_ip=*)
    dest_ip="${i#*=}"
    shift # past argument=value
    ;;
    -i=*|--dest_ip=*)
    dest_ip="${i#*=}"
    shift # past argument=value
    ;;
    -c|--python_custom)
    echo "Note: '$i' is deprecated, please avoid using it"
    shift
    ;;
    -d=*|--data_set=*)
    data_set="${i#*=}"
    shift
    ;;
    *)
    # unknown option
    echo "Unknown option: '${i#*=}', Please use --help for valid options list"
    exit 1
    ;;
esac
done


function prepare_morpheus_data_sets() {
# prepare fieldset and counterset file
cat << EOF >> "morpheus_FI.fset"
[flow_inspector_event_*]
meta_field_add:message_type=Packet
[nvidia_smi_event_*]
meta_field_alias:hostname=aid
meta_field_add:active=true
meta_field_add:deleted=false
meta_field_add:message_type=GpuStat

[xid_rsyslog_line]
meta_field_alias:hostname=aid
meta_field_add:message_type=GpuStat
EOF

    mv  morpheus_FI.fset $fb_conf_dir/morpheus_FI.fset

    # prepare counterset file to skip counters:
    cat << EOF >> "morpheus_FI.cset"
this_counter_fits_nothing
EOF
    mv morpheus_FI.cset $fb_conf_dir/morpheus_FI.cset
}

if [[ x"$dest_ip" == x"" || x"$dest_port" == x"" ]] ; then
    echo "Set required arguments should be set. Please use '$0 --help' for help"
    exit 0
fi

fb_conf_dir=/config/fluent_bit_configs

rm -rf $fb_conf_dir
cp -r  /telemetry.config_original/fluent_bit_configs $fb_conf_dir


# enable forward plugin
forward_env_path=$fb_conf_dir/forward.exp

if [[ x"$data_set" == x"morpheus" ]] ; then
    prepare_morpheus_data_sets
    orig_line="#fieldset=\/path\/to\/fset_file.fset"
    targ_line="fieldset=\/config\/fluent_bit_configs\/morpheus_FI.fset"
    sed -i "s/${orig_line}/${targ_line}/g"       $forward_env_path

    orig_line="#counterset=\/path\/to\/cset_file.cset"
    targ_line="counterset=\/config\/fluent_bit_configs\/morpheus_FI.сset"
    sed -i "s/${orig_line}/${targ_line}/g"       $forward_env_path
fi


sed -i "s/enable=0/enable=1/g"               $forward_env_path
sed -i "s/host=localhost/host=${dest_ip}/g"  $forward_env_path
sed -i "s/port=24224/port=${dest_port}/g"    $forward_env_path
