#!/bin/sh
# Copyright (C) Mellanox Technologies Ltd. 2018. ALL RIGHTS RESERVED.
# See file LICENSE for terms.
#
# Aggregation server Python environment.
#
script_real_path=$(realpath "$0")
script_dir_name=$(dirname "${script_real_path}")
root_dir="$(realpath "${script_dir_name}/../..")"

CONFIG_DIR=${CONFIG_DIR:-/config}
agx_env=$CONFIG_DIR/agx.env

if [ ! -f "$agx_env" ]; then
    echo "Error: unable to find agx.env file in ${agx_env}"
    exit 1
fi

. "${agx_env}"


if [ "${COLLECTX_MODE}" = "DPU_TELEMETRY" ]; then

    VENV_FOLDER="${root_dir}/venv3"

    if [ ! -d "${VENV_FOLDER}" ]; then
        echo "Error: unable to find envirnment folder ${VENV_FOLDER}"
        exit 1
    fi

    . "${VENV_FOLDER}/bin/activate"
fi



# create SERVER_LOG_DIR if doens't exist
if [ ! -d "${SERVER_LOG_DIR}" ]; then
    mkdir -p "${SERVER_LOG_DIR}"
fi

if [ "$#" -ne 0 ]; then
    eval "$*"
fi
