"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""

import re

from services.modules.base_module import BaseModule
from services.modules.run_command.command_manager import CommandManager


class Memory(BaseModule):
    """
    Memory class
    """
    def get_memory_info(self):
        data: dict = {}
        # free
        result = CommandManager.run_command(connection=self.connection, command='free -k')
        if result.rc == 0:
            # free -m
            #       total        used        free      shared  buff/cache   available
            # Mem:           3949        2072         713         216        1163        1260
            # Swap:          1999          21        1978

            match = re.search(r'Mem:\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)', result.output)
            if match:
                total = match.group(1)
                used = match.group(2)
                available = match.group(6)
                current_threshold = int((float(used) / float(total)) * 100)
                data['total'] = {'value': str(total), 'unit': 'KBytes'}
                data['used'] = {'value': str(used), 'unit': 'KBytes'}
                data['free'] = {'value': str(available), 'unit': 'KBytes'}
                data['usages'] = {'value': current_threshold, 'unit': '%'}
            if not data:
                result.update_logger_fail_to_parse_output()

        return data
