"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model
from services.modules.system.general.general import General
from services.modules.system.storage.storage import Storage


class GeneralInfo:
    """
    GeneralInfo class
    """
    @classmethod
    def get_general_info(cls):
        """
        get general info
        :return: dict of data
        """
        data = {}
        general_obj = General(Model.connection)
        data['Host Name'] = general_obj.get_host_name()
        data['OS Name'] = general_obj.get_os_name().strip('"')
        data['OS Version'] = general_obj.get_os_version().strip('"')
        data['Kernel Version'] = general_obj.get_kernel_version()
        data['Kernel Release'] = general_obj.get_kernel_release()
        data['Driver'] = general_obj.get_drivername_and_version()
        data['DOCA Version'] = general_obj.get_doca_version()
        data['Bluefield OS Version'] = general_obj.get_bluefield_os_version()
        res = general_obj.get_board_id_part_serial_number()
        data.update(res)
        res = general_obj.show_lifecycle_state()
        data.update(res)
        res = general_obj.show_secure_boot_state()
        data.update(res)
        return data

    @classmethod
    def show_nvme_info(cls):
        """
        show NVME info
        :return: list
        """
        res_data = []
        res = Storage(Model.connection).get_nvme_info()
        if res and res.get("Devices"):
            data = res.get("Devices")
            for d in data:
                str_dict = {key: str(value) for key, value in d.items()}
                res_data.append(str_dict)
        return res_data

    @classmethod
    def show_emmc_config_info_and_identification(cls) -> dict:
        """
        show emmc config info and identification
        :return: dict
        """
        res_data = {}
        res = Storage(Model.connection).get_emmc_identification()
        res_data["identification"] = res
        res = Storage(Model.connection).get_emmc_config_info()
        res_data["config_info"] = res
        return res_data