#!/bin/sh
# Copyright (C) Mellanox Technologies Ltd. 2018. ALL RIGHTS RESERVED.
# See file LICENSE for terms.
#
# Aggregation server Python environment.
#
export AGX_ROOT="${AGX_ROOT:-/opt/mellanox/collectx}"
export CLX_ROOT="${CLX_ROOT:-/opt/mellanox/collectx}"

# Configure hardware counters access
# Perf component of PAPI provider requires perf_event_paranoid set to 0
# to allow running CollectX daemon as non-root.
# What you can do with perf without being root depends on the kernel.perf_event_paranoid sysctl setting.
#    kernel.perf_event_paranoid = 2: you can't take any measurements.
#    kernel.perf_event_paranoid = 1: you can trace a command with perf stat or perf record, and get kernel profiling data.
#    kernel.perf_event_paranoid = 0: you can trace a command with perf stat or perf record, and get CPU event data.
#    kernel.perf_event_paranoid = -1: you get raw access to kernel tracepoints (specifically, you can mmap the file created by perf_event_open.
echo 0 | tee /proc/sys/kernel/perf_event_paranoid >/dev/null

# PCM provider requires disabling NMI watchdog
echo 0 | tee /proc/sys/kernel/nmi_watchdog  >/dev/null

# Both PCM and PAPI RAPL uses the MSR kernel module to read model specific
# registers (MSRs) from user space.
chmod 666 /dev/cpu/*/msr

# enable mlx5_fw tracing for qp_provider
fw_tracer_before_ofed_4_6="/sys/kernel/debug/tracing/events/mlx5/fw_tracer/enable"
fw_tracer_ofed_4_6_and_above="/sys/kernel/debug/tracing/events/mlx5/mlx5_fw/enable"

if [ -f "$fw_tracer_before_ofed_4_6" ]; then
    echo 1 > $fw_tracer_before_ofed_4_6
fi

if [ -f "$fw_tracer_ofed_4_6_and_above" ]; then
    echo 1 > $fw_tracer_ofed_4_6_and_above
fi

if [ "$#" -ne 0 ]; then
    eval "$*"
fi
