#!/bin/bash

SCRIPT_PATH=$(realpath $0)
CONFIG_FILE=$1
BIN_DIR=${BIN_DIR:-$(dirname $SCRIPT_PATH)}

[ -z "$BIN_DIR" ] && echo "BIN_DIR not set" && exit 1

# verify config file
[ -z "$CONFIG_FILE" ] && echo "no config file" && exit 1
[ ! -f "$CONFIG_FILE" ] && echo "$CONFIG_FILE not a file" && exit 1

RUN_SERVER=0
RUN_SERVER=$(egrep ^run_gnmi_server $CONFIG_FILE | grep 1 | wc -l)
[[ "$RUN_SERVER" != "1" ]] && echo "gNMI server is disabled" && exit 0

sleep 10  # wait for ibdiagnet to start
executable=${BIN_DIR}/gnmi_server
[ ! -f $executable ] && echo "gnmi_server executable not found" && exit 0

$executable -i 127.0.0.1
