"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import re

from services.modules.base_module import BaseModule
from services.modules.run_command.command_manager import CommandManager


class Kernel(BaseModule):
    """
    Kernel class
    """
    def verify_loaded_kernel_modules(self, expexted_loaded_module: list):
        """
        get mlxconfig default current and next boot info
        :return: dict of info
        """
        data: list = []
        result = CommandManager.run_command(connection=self.connection,command='lsmod')
        # lsmod |grep -i mlx
        # Module                  Size  Used by
        # stp                    16384  2 bridge,garp
        # mrp                    20480  1 8021q
        # llc                    16384  3 bridge,stp,garp
        # act_skbedit            16384  0
        # act_mirred             24576  0
        # ib_ipoib              151552  0
        # nfnetlink_cttimeout    20480  0
        # nfnetlink              20480  2 nfnetlink_cttimeout
        # act_gact               20480  0
        # cls_flower             45056  0
        # sch_ingress            16384  5
        # openvswitch           155648  4
        # nsh                    16384  1 openvswitch
        # nf_conncount           24576  1 openvswitch
        # nf_nat                 53248  1 openvswitch
        # mst_pciconf           323584  0
        # ib_umad                32768  0
        # binfmt_misc            24576  1
        # dm_multipath           36864  0
        # sbsa_gwdt              20480  0
        # mlx5_ib               397312  0
        # uio_pdrv_genirq        16384  0
        # uio                    24576  1 uio_pdrv_genirq
        # mlxbf_pmc              36864  0
        # mlxbf_pka             118784  0
        # mlx_trio               20480  0
        # mlx_bootctl            28672  0
        # bluefield_edac         16384  0
        # sch_fq_codel           20480  19

        if result.rc == 0:
            loaded_data: list = []
            unloaded_data: list = []
            match = re.findall(r'(^\s*\S+)\s+\d+', result.output, re.MULTILINE)
            if match:
                loaded_module = match
                for module in expexted_loaded_module:
                    result = CommandManager.run_command(connection=self.connection,command=f'modinfo {module} -d')
                    if result.rc == 0:
                        match = re.search(r'(.*)', result.output)
                        if match:
                            if module in loaded_module:
                                loaded_data.append({'module': module, 'description': match.group(1), 'loaded': 'yes'})
                            else:
                                unloaded_data.append({'module': module, 'description': match.group(1), 'loaded': 'no'})
            unloaded_data.extend(loaded_data)
            data = unloaded_data
            if not data:
                result.update_logger_fail_to_parse_output()
        return data
