"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model
from services.modules.firmware.firmware import Firmware
from services.modules.system.general.general import General


class FirmwareInfo:
    """
    FirmwareInfo class
    """
    @classmethod
    def get_firmware_info(cls,device):
        """
        get firmware info ordered by changed, include default/curent/nextboot info
        :device: device specific
        :return: list of dictionary of data
        """
        changed_data:list = []
        non_changed_data:list = []
        firmware_obj = Firmware(Model.connection)
        data = firmware_obj.get_mlxconfig_default_current_and_nextboot_info(device=device)
        for dec , infos in data.items():
            if infos[3] == 'CHANGED':
                changed_data.append({dec:infos})
            else:
                non_changed_data.append({dec:infos})

        changed_data.extend(non_changed_data)

        #####
        total_data: list = []

        fw_info = firmware_obj.get_mlxconfig_fields_info()
        for field in changed_data:
            for field_name in field.keys():
                field_data_list = field.get(field_name)
                if isinstance(field_data_list, list):
                    data: dict = {}
                    data['field_name'] = field_name
                    if fw_info.get(field_name):
                        data.update(fw_info.get(field_name))

                    if len(field_data_list) >= 3:
                        data['default'] = field_data_list[0]
                        data['current'] = field_data_list[1]
                        data['next_boot'] = field_data_list[2]
                        if field_data_list[3] == 'CHANGED':
                            data['changed'] = True
                            total_data.append(data)
                        else:
                            data['changed'] = False
                            total_data.insert(len(total_data), data)
        return total_data

    @classmethod
    def get_all_ports_fw_info(cls):
        """
        get all ports firmware info
        :return: list of data
        """
        data = []
        buses = General(Model.connection).get_dpu_port_buses()
        buses.sort()
        for bus in buses:
            res = FirmwareInfo.get_firmware_info(device=bus)
            data.append(res)

        return data
