"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model
from services.modules.system.host_configuration.host_configuration import HostConfiguration


class DpuOperationModeInfo:
    """
    Dpu Operation Mode Info class
    """
    @classmethod
    def get_dpu_operation_mode_info(cls):
        """
        get dpu operation mode info
        :return: dictionary of dictionaries of data
        """
        return HostConfiguration(Model.connection).get_host_configuration_and_port_functions_status()