"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""

from services.blueman.models.model import Model
from services.modules.kernel.kernel import Kernel
from services.modules.netdevice.interface import Interface
from services.modules.system.service.service import SystemService


class Services:
    """
    Services class
    """
    @classmethod
    def get_system_service_health(cls):
        """
        get the systemctl services that sorted by failed and adding the status info of the failed services
        :return:
        """
        result_data:list = []
        failed_data: list = []
        unfailed_data: list = []
        system_service_obj = SystemService(Model.connection)
        failed_data , unfailed_data = system_service_obj.get_systemctl_list_units_services()
        exclude_sevices = Model.verifier_config().failed_services_to_exclude

        for f_data in failed_data:
            service_name = f_data.get('UNIT')
            if service_name:
                if service_name in exclude_sevices:
                    unfailed_data.append(f_data)
                    continue
                result = system_service_obj.get_systemctl_service_status(service_name)
                if result:
                    tmp_data = f_data
                    tmp_data['Failed Reason'] = result.strip()
                    result_data.append(tmp_data)
        result_data = result_data + unfailed_data
        return result_data

    @classmethod
    def get_kernel_modules_health(cls):
        """
        get kernel modules
        :return: kernel modules status
        """
        if Interface(Model.connection).is_all_pfs_link_layer_ethernet():
            expected_loaded_modules = Model.verifier_config().kernel_modules_ethernet
        else:
            expected_loaded_modules = Model.verifier_config().kernel_modules_infiniband
        data = Kernel(Model.connection).verify_loaded_kernel_modules(expected_loaded_modules)
        return data