"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
from services.blueman.models.model import Model


class DocaService:
    """
    Doca Service class
    """
    @classmethod
    def get_doca_services(cls):
        """
        get doca sevices
        :return:
        """
        from services.modules.crictl.crictl import Crictl
        crictl_obj = Crictl(Model.connection)
        res = crictl_obj.get_containers(name='doca')
        result_data:list = []
        for container_info in res:
            container_info_tmp:dict = container_info
            container_id = container_info.get('CONTAINER')
            if container_id:
                res = crictl_obj.get_container_logs(container_id=container_id)
                container_info_tmp['LOGS'] = res
                result_data.append(container_info_tmp)
        return result_data
