"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import re

from services.blueman.models.model import Model

class DTS:
    """
    DOCA Telemetry service
    """

    @classmethod
    def get_doca_telemetry_service_counters(cls):
        """
        get DTS service counters, exclude counters with 0 value , exclude none up port_state
        """
        from services.modules.doca_telemetry_service.doca_telemetry_service import DocaTelemetryService
        result = DocaTelemetryService(Model.connection).get_doca_telemetry_service_counters_data()
        result_data = {}
        result_counters_info = []
        for provider_name, provider_data_list in result.items():
            result_data.update({provider_name:[]})
            devices_to_exclude = []
            device_and_sorted_counters = {}
            for provider_device_data in provider_data_list:#list of device data of specific provider
                counters = provider_device_data.get('counters')
                device_name = provider_device_data.get('device_name')
                sorted_device_provider_counter = []
                for counter_data in counters:#counters of device
                    counter_name = counter_data.get('counter_name')
                    counter_value = counter_data.get('counter_value')

                    if (counter_name == 'ib_port_state' or counter_name == 'hw_port_state') and counter_value != 4:
                        sorted_device_provider_counter.clear()
                        devices_to_exclude.append(device_name)
                        break
                    elif counter_value == 0:
                        continue
                    else:
                        sorted_device_provider_counter.append(counter_name)
                if sorted_device_provider_counter:
                    sorted_device_provider_counter = sorted(sorted_device_provider_counter)
                    if device_name not in devices_to_exclude:
                        device_and_sorted_counters.update({device_name:sorted_device_provider_counter})
            for device in sorted(device_and_sorted_counters):
                for provider_device_data in provider_data_list:  # list of device data of specific provider
                    device_name = provider_device_data.get('device_name')
                    if device_name == device:
                        sorted_counter_data = []
                        counters = provider_device_data.get('counters')
                        for s_counter in device_and_sorted_counters.get(device):
                            for counter_data in counters:  # counters of device
                                counter_name = counter_data.get('counter_name')
                                if counter_name == s_counter:
                                    counter_value = counter_data.get('counter_value')
                                    if re.search(r'drop|error', counter_name, re.IGNORECASE) and counter_value > 0:
                                        counter_data['failed_counter'] = True
                                        sorted_counter_data.insert(0,counter_data)
                                    else:
                                        counter_data['failed_counter'] = False
                                        sorted_counter_data.append(counter_data)
                                    break
                        provider_device_data.update({'counters':sorted_counter_data})
                        result_data.get(provider_name).append(provider_device_data)
                        break
        for provider in sorted(result_data):
            result_counters_info.append({provider : result_data.get(provider)})
        return result_counters_info