# mlx_steering_dump_parser
This is Mellanox SW steering parser and triggering for dump files in **CSV format**.

For JSON dump parser please move to branch [`json_parser`](https://github.com/Mellanox/mlx_steering_dump/tree/json_parser).

How to trigger a dump file generation
=====================================
Dump generation is available in:

    1. rdma-core:
        It can be done directly by calling mlx5dv_dump_dr_domain API or using mlx5_pmd
        To trigger DPDK app run:
            mlx_steering_dump_parser.py -p <DPDK PID> -f <dump_file>

    2. Kernel SMFS on new OFED / Kernel Upstream (Linux kernel starting with 5.17 or MLNX_OFED >= 5.7):
        The steering information in CSV form can be read at the following path:
            /sys/kernel/debug/mlx5/<PCI>/steering/fdb/<domain_handle>
        Example:
            cat /sys/kernel/debug/mlx5/0000:82:00.0/steering/fdb/dmn_000018644 > dump_file
            mlx_steering_dump_parser.py -f dump_file

    3. Kernel SMFS on older MLNX-OFED (versions before OFED 5.7):
        Generated by reading the proc file at the following path:
            cat /proc/driver/mlx5_core/smfs_dump/fdb/<PCI>
        Example:
            cat /proc/driver/mlx5_core/smfs_dump/fdb/0000:82:00.0 > dump_file
            mlx_steering_dump_parser.py -f dump_file

Running syntax
================

| Flags | meaning |
| :---: | :---: |
| -f <PATH> | path to file |
| -r  | show raw data |
| -t  | Show steering tree/hierarchy    |
| -p <DPDK PID> | Trigger DPDK app           |
| -v  | Verbose view               |
| -vv | Extra verbose view      |
| -c  | show colored prints |

Running examples
================

example.csv is part of this porject can be viewed using:

	mlx_steering_dump_parser.py -f example.csv
	mlx_steering_dump_parser.py -f example.csv -t
	mlx_steering_dump_parser.py -f example.csv -v
	mlx_steering_dump_parser.py -f example.csv -tvv

Trigger a new testpmd dump using:

	mlx_steering_dump_parser.py -p `pidof testpmd` -f new_dump.csv

Trigger a new kernel SMFS dump using new OFED/Upstream:

	cat /sys/kernel/debug/mlx5/0000\:08\:00.0/steering/fdb/dmn_000000006c154714 > /new_dump.csv
	mlx_steering_dump_parser.py -f /new_dump.csv

Trigger a new kernel SMFS dump using old OFED:

	cat /proc/driver/mlx5_core/smfs_dump/fdb/0000\:82\:00.0 > /new_dump.csv
	mlx_steering_dump_parser.py -f /new_dump.csv

Recommended packages
==================
Python 2 or 3

Support
==================
OFED kernel proc dump support from OFED 5.0.2

RDMA CORE user dump support from version 28.0

TESTPMD trigger dump support from version 17.11
