#!/bin/bash -eE

function update_line ()
{
    line_to_set=$1
    file=$2

    key=${line_to_set%=*}

    if grep "${key}" "${file}"; then
        # replace line
        sed -i -e "/${key}/c\\${line_to_set}" "${file}"
    else
        # append line
        sed -i -e "\$a${line_to_set}" "${file}"
    fi
}

# wait until run_ibmgtsim.py starts and provides us all necessaty env variables
sim_log_file="/var/log/run_ibmgtsim.log"
while :
do
    echo "while...."
    if ! IBMGTSIM_DIR_srt=$(grep 'export IBMGTSIM_DIR=' "${sim_log_file}"); then
        echo "no IBMGTSIM_DIR"
        continue
    fi

    if ! LD_PRELOAD_srt=$(grep 'export LD_PRELOAD=' "${sim_log_file}"); then
        echo "no LD_PRELOAD"
        continue
    fi

    if ! IBMGTSIM_SERVER_srt=$(grep 'export IBMGTSIM_SERVER=' "${sim_log_file}"); then
        echo "no IBMGTSIM_SERVER"
        continue
    fi

    echo "done"
    break
done

# preparing env variables
IBMGTSIM_DIR_srt=${IBMGTSIM_DIR_srt//export /plugin_env_}
LD_PRELOAD_srt=${LD_PRELOAD_srt//export /plugin_env_}
IBMGTSIM_SERVER_srt=${IBMGTSIM_SERVER_srt//export /plugin_env_}

echo "IBMGTSIM_DIR_srt = ${IBMGTSIM_DIR_srt}"
echo "LD_PRELOAD_srt = ${LD_PRELOAD_srt}"
echo "IBMGTSIM_SERVER_srt = ${IBMGTSIM_SERVER_srt}"


# update /config/launch_ibdiagnet_config.ini
config_file="/config/launch_ibdiagnet_config.ini"
update_line "${IBMGTSIM_DIR_srt}" ${config_file}
update_line "${LD_PRELOAD_srt}" ${config_file}
update_line "${IBMGTSIM_SERVER_srt}" ${config_file}

echo "Done"

/opt/mellanox/collectx/telem/bin/launch_ibdiagnet --config /config/launch_ibdiagnet_config.ini &>> /var/log/launch_ibdiagnet.log
