#!/bin/bash

HWMON_ROOT=/sys/class/hwmon

events_write_l3cache() {
    local path=$1

    dirs=$( find $path/ -name "l3cache*" )
    for d in $dirs; do
        echo 0x01 > $d/event0  # CYCLES
        echo 0x17 > $d/event1  # HITS_BANK0
        echo 0x18 > $d/event2  # HITS_BANK1
        echo 0x02 > $d/event3  # TOTAL_RD_REQ_IN
        echo 0x03 > $d/event4  # TOTAL_WR_REQ_IN
        echo 1 > $d/enable
    done
}

events_write_tile_and_tilenet() {
    local path=$1

    dirs=$( find $path/ -name "tile*" )
    for d in $dirs; do
        if [[ "${d}" == *"tilenet"* ]]; then
            # tilenet
            echo 0x12 > $d/event0  # CDN_REQ
            echo 0x13 > $d/event1  # DDN_REQ
            echo 0x14 > $d/event2  # NDN_REQ
            echo 0x19 > $d/event3  # CDN_DIAG_C_OUT_OF_CRED
        else
            # tile
            echo 0x4c > $d/event0  # MEMORY_READS
            echo 0x4d > $d/event1  # MEMORY_WRITES
            echo 0x4e > $d/event2  # VICTIM_WRITE
            echo 0x67 > $d/event3  # MSS_NO_CREDIT
        fi
    done
}

events_write_trio_and_triogen() {
    local path=$1

    dirs=$( find $path/ -name "trio*" )
    for d in $dirs; do
        if [[ "${d}" == *"triogen"* ]]; then
            # triogen
            echo 0xf > $d/event0  # TX_DAT_AF
        else
            # trio
            echo 0xa8 > $d/event0  # TDMA_RT_AF
            echo 0xa9 > $d/event1  # TDMA_PBUF_MAC_AF
            echo 0xa0 > $d/event2  # TPIO_DATA_BEAT
            echo 0xa1 > $d/event3  # TDMA_DATA_BEAT
        fi
    done
}

prepare_bf2_counters() {
    local p="$1"
    events_write_l3cache "$p"
    events_write_tile_and_tilenet "$p"
    events_write_trio_and_triogen "$p"
}

events_write_llt() {
    local path="$1"

    dirs=$( find $path/ -name "llt*" )
    for d in $dirs; do
        if [[ "${d}" == *"llt_miss"* ]]; then
            # llt_miss
            echo 0x00 > "$d"/event0 # GDC_MISS_MACHINE_RD_REQ
            echo 0x01 > "$d"/event1 # GDC_MISS_MACHINE_WR_REQ
        else
            # llt
            echo 0x54 > "$d"/event0 # GDC_BANK0_RD_REQ
            echo 0x7b > "$d"/event1 # GDC_BANK1_RD_REQ
            echo 0x55 > "$d"/event2 # GDC_BANK0_WR_REQ
            echo 0x7c > "$d"/event3 # GDC_BANK1_WR_REQ
        fi
        echo 1 > "$d"/enable
    done
}

events_write_mss() {
    local path="$1"

    dirs=$( find $path/ -name "mss*" )
    for d in $dirs; do
        echo 0x01 > "$d"/event0 # SKYLIB_DDN_TX_FLITS
        echo 0x06 > "$d"/event1 # SKYLIB_DDN_RX_FLITS
        echo 1 > "$d"/enable
    done
}

prepare_bf3_counters() {
    local p="$1"
    events_write_llt "$p"
    events_write_mss "$p"
}

paths=$( find $HWMON_ROOT/ -name "hwmon*" )
for p in $paths; do

    # make sure we are working in hwmon of PMC driver
    name_file="$p/name"
    [ ! -f "$name_file" ] && continue
    name=$( cat "$name_file" ||:)
    [[ "$name" != *"bfperf"* ]] && continue

    prepare_bf2_counters "$p"
    prepare_bf3_counters "$p"
done
