"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.

This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import json
from services.modules.base_module import BaseModule
from services.modules.run_command.command_manager import CommandManager
from services.modules.system.general.general import General


class Package(BaseModule):
    """
    Package class
    """

    def get_installed_packages(self):
        """
        get installed packages
        """
        data = []
        try:
            general_obj = General(self.connection)
            if general_obj.is_ubuntu_family():
                cmd = """dpkg-query --show -f \'{"package_name": "${Package}","version": "${Version}","status": "${Status}"}\n\'"""
            elif general_obj.is_redhat_family():
                cmd = """rpm -qa --queryformat '\{"package_name": "%{NAME}", "version": "%{VERSION}", "status": "installed"\}\n'"""
            else:
                return data
            result = CommandManager.run_command(connection=self.connection, command=cmd)
            if result.rc == 0:
                data = []
                packages_as_str = result.output.splitlines()
                for pckg_str in packages_as_str:
                    as_dict = json.loads(pckg_str)
                    data.append(as_dict)
        except Exception as exp:
            self.logger.error(exp)
        return data