"""
Copyright © 2019-2022 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
 
This software product is a proprietary product of Nvidia Corporation and its affiliates
(the "Company") and all right, title, and interest in and to the software
product, including all associated intellectual property rights, are and
shall remain exclusively with the Company.

This software product is governed by the End User License Agreement
provided with the software product.
"""
import re

from services.modules.base_module import BaseModule
from services.modules.run_command.command_manager import CommandManager


class Logs(BaseModule):
    """
    clogs class
    """
    def verify_system_logs_error_messages(self):
        """
        verify system logs error messages
        :return:
        """
        for log in ['syslog', 'messages']:
            result = CommandManager.run_command(connection=self.connection, command=f'ls /var/log/{log}')
            if result.rc == 0:
                result = CommandManager.run_command(connection=self.connection,
                                                    command=f'cat /var/log/{log} |grep -i "error\|fail\|call trace\|rip\|panic"')
                if result.rc == 0:
                    return result.output
        return ''

    def verify_dmesg_error_messages(self):
        """
        verify dmesg error
        :return:
        """
        result = CommandManager.run_command(connection=self.connection,
                                            command=f'dmesg |grep -i "error\|fail\|call trace\|rip\|panic"')
        if result.rc == 0:
            return result.output
        return ''

    def verify_ovs_error_messages(self):
        """
        verify ovs error
        :return:
        """
        result = CommandManager.run_command(connection=self.connection,
                                            command=f'cat /var/log/openvswitch/ovs-vswitchd.log |grep -i "error\|fail\|call trace\|rip\|panic"')

        if result.rc == 0:
            return result.output
        return ''

    def show_dmesg(self):
        """
        show dmesg
        :return: list of dict
        """
        data:list = []
        result = CommandManager.run_command(connection=self.connection, command=f'dmesg -T')
        if result.rc == 0:
            # output example:
            # [Wed Dec 22 15:11:19 2021] mlx5_core 0000:03:00.1: mlx5_wait_for_pages:774:(pid 1828474): Skipping wait for vf pages stage
            # [Wed Dec 22 15:11:19 2021] mlx5_core 0000:03:00.1: mlx5_wait_for_pages:774:(pid 1828474): Skipping wait for vf pages stage
            # [Wed Dec 22 15:11:20 2021] mlx5_core 0000:03:00.1: E-Switch: cleanup
            # [Wed Dec 22 15:11:20 2021] mlx5_core 0000:03:00.0: mlx5_wait_for_pages:774:(pid 1828474): Skipping wait for vf pages stage
            match = re.findall(r'(\[\w+\s+\w+\s+\d+\s+\d+:\d+:\d+\s+\d+\])\s+(.*)',result.output)
            if match:
                for raw in match:
                    data.append({'Date': raw[0], 'Description': raw[1]})
            if not data:
                result.update_logger_fail_to_parse_output()
        return data

    def show_bf_rshim_log(self):
        """
        show bluefield rshim log
        :return: list
        """
        data:list = []
        result = CommandManager.run_command(connection=self.connection, command=f'bfrshlog')
        if result.rc == 0:
            # output example:
            # # bfrshlog
            #  INFO[MISC]: PSC BL1 START
            #  INFO[BL2]: start
            #  INFO[BL2]: DDR POST passed
            #  INFO[BL2]: UEFI loaded
            #  INFO[BL31]: start
            #  INFO[BL31]: lifecycle Production
            #  INFO[BL31]: VDD adjustment complete
            #  INFO[BL31]: VDD adjustment complete
            #  INFO[BL31]: power capping disabled
            #  INFO[BL31]: runtime
            data = result.output.splitlines()
            if not data:
                result.update_logger_fail_to_parse_output()
        return data